% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotEquiMap.R
\name{PlotEquiMap}
\alias{PlotEquiMap}
\title{Maps A Two-Dimensional Variable On A Cylindrical Equidistant Projection}
\usage{
PlotEquiMap(var, lon, lat, varu = NULL, varv = NULL, toptitle = NULL,
  sizetit = NULL, units = NULL, brks = NULL, cols = NULL,
  bar_limits = NULL, triangle_ends = NULL, col_inf = NULL,
  col_sup = NULL, colNA = NULL, color_fun = clim.palette(),
  square = TRUE, filled.continents = NULL, coast_color = NULL,
  coast_width = 1, contours = NULL, brks2 = NULL, contour_lwd = 0.5,
  contour_color = "black", contour_lty = 1, contour_label_scale = 1,
  dots = NULL, dot_symbol = 4, dot_size = 1,
  arr_subsamp = floor(length(lon)/30), arr_scale = 1, arr_ref_len = 15,
  arr_units = "m/s", arr_scale_shaft = 1, arr_scale_shaft_angle = 1,
  axelab = TRUE, labW = FALSE, intylat = 20, intxlon = 20,
  axes_tick_scale = 1, axes_label_scale = 1, drawleg = TRUE,
  subsampleg = NULL, bar_extra_labels = NULL, draw_bar_ticks = TRUE,
  draw_separators = FALSE, triangle_ends_scale = 1, bar_label_digits = 4,
  bar_label_scale = 1, units_scale = 1, bar_tick_scale = 1,
  bar_extra_margin = rep(0, 4), boxlim = NULL, boxcol = "purple2",
  boxlwd = 5, margin_scale = rep(1, 4), title_scale = 1, numbfig = NULL,
  fileout = NULL, width = 8, height = 5, size_units = "in", res = 100,
  ...)
}
\arguments{
\item{var}{Array with the values at each cell of a grid on a regular 
rectangular or gaussian grid. The array is expected to have two 
dimensions: c(latitude, longitude). Longitudes can be in ascending or 
descending order and latitudes in any order. It can contain NA values 
(coloured with 'colNA'). Arrays with dimensions c(longitude, latitude) 
will also be accepted but 'lon' and 'lat' will be used to disambiguate so 
this alternative is not appropriate for square arrays.}

\item{lon}{Numeric vector of longitude locations of the cell centers of the 
grid of 'var', in ascending or descending order (same as 'var'). Expected 
to be regularly spaced, within either of the ranges [-180, 180] or 
[0, 360]. Data for two adjacent regions split by the limits of the 
longitude range can also be provided, e.g. \code{lon = c(0:50, 300:360)} 
('var' must be provided consitently).}

\item{lat}{Numeric vector of latitude locations of the cell centers of the 
grid of 'var', in any order (same as 'var'). Expected to be from a regular 
rectangular or gaussian grid, within the range [-90, 90].}

\item{varu}{Array of the zonal component of wind/current/other field with 
the same dimensions as 'var'.}

\item{varv}{Array of the meridional component of wind/current/other field 
with the same dimensions as 'var'.}

\item{toptitle}{Top title of the figure, scalable with parameter 
'title_scale'.}

\item{sizetit}{Scale factor for the figure top title provided in parameter 
'toptitle'. Deprecated. Use 'title_scale' instead.}

\item{units}{Title at the top of the colour bar, most commonly the units of 
the variable provided in parameter 'var'.}

\item{brks, cols, bar_limits, triangle_ends}{Usually only providing 'brks' is 
enough to generate the desired colour bar. These parameters allow to 
define n breaks that define n - 1 intervals to classify each of the values 
in 'var'. The corresponding grid cell of a given value in 'var' will be 
coloured in function of the interval it belongs to. These parameters are 
sent to \code{ColorBar()} to generate the breaks and colours. Additional 
colours for values beyond the limits of the colour bar are also generated 
and applied to the plot if 'bar_limits' or 'brks' and 'triangle_ends' are 
properly provided to do so. See ?ColorBar for a full explanation.}

\item{col_inf, col_sup, colNA}{Colour identifiers to colour the values in 
'var' that go beyond the extremes of the colour bar and to colour NA 
values, respectively. 'colNA' takes attr(cols, 'na_color') if available by 
default, where cols is the parameter 'cols' if provided or the vector of 
colors returned by 'color_fun'. If not available, it takes 'pink' by 
default. 'col_inf' and 'col_sup' will take the value of 'colNA' if not 
specified. See ?ColorBar for a full explanation on 'col_inf' and 'col_sup'.}

\item{color_fun, subsampleg, bar_extra_labels, draw_bar_ticks, draw_separators, triangle_ends_scale, bar_label_digits, bar_label_scale, units_scale, bar_tick_scale, bar_extra_margin}{Set of parameters to control the visual 
aspect of the drawn colour bar. See ?ColorBar for a full explanation.}

\item{square}{Logical value to choose either to draw a coloured square for 
each grid cell in 'var' (TRUE; default) or to draw contour lines and fill 
the spaces in between with colours (FALSE). In the latter case, 
'filled.continents' will take the value FALSE if not specified.}

\item{filled.continents}{Colour to fill in drawn projected continents. 
Takes the value gray(0.5) by default or, if 'square = FALSE', takes the 
value FALSE. If set to FALSE, continents are not filled in.}

\item{coast_color}{Colour of the coast line of the drawn projected continents.
Takes the value gray(0.5) by default.}

\item{coast_width}{Line width of the coast line of the drawn projected 
continents. Takes the value 1 by default.}

\item{contours}{Array of same dimensions as 'var' to be added to the plot 
and displayed with contours. Parameter 'brks2' is required to define the 
magnitude breaks for each contour curve. Disregarded if 'square = FALSE'.}

\item{brks2}{Vector of magnitude breaks where to draw contour curves for the 
array provided in 'contours' or if 'square = FALSE'.}

\item{contour_lwd}{Line width of the contour curves provided via 'contours' 
and 'brks2', or if 'square = FALSE'.}

\item{contour_color}{Line color of the contour curves provided via 'contours' 
and 'brks2', or if 'square = FALSE'.}

\item{contour_lty}{Line type of the contour curves. Takes 1 (solid) by 
default. See help on 'lty' in par() for other accepted values.}

\item{contour_label_scale}{Scale factor for the superimposed labels when 
drawing contour levels.}

\item{dots}{Array of same dimensions as 'var' or with dimensions 
c(n, dim(var)), where n is the number of dot/symbol layers to add to the 
plot. A value of TRUE at a grid cell will draw a dot/symbol on the 
corresponding square of the plot. By default all layers provided in 'dots' 
are plotted with dots, but a symbol can be specified for each of the 
layers via the parameter 'dot_symbol'.}

\item{dot_symbol}{Single character/number or vector of characters/numbers 
that correspond to each of the symbol layers specified in parameter 'dots'. 
If a single value is specified, it will be applied to all the layers in 
'dots'. Takes 15 (centered square) by default. See 'pch' in par() for 
additional accepted options.}

\item{dot_size}{Scale factor for the dots/symbols to be plotted, specified 
in 'dots'. If a single value is specified, it will be applied to all 
layers in 'dots'. Takes 1 by default.}

\item{arr_subsamp}{Subsampling factor to select a subset of arrows in 
'varu' and 'varv' to be drawn. Only one out of arr_subsamp arrows will 
be drawn. Takes 1 by default.}

\item{arr_scale}{Scale factor for drawn arrows from 'varu' and 'varv'. 
Takes 1 by default.}

\item{arr_ref_len}{Length of the refence arrow to be drawn as legend at the 
bottom of the figure (in same units as 'varu' and 'varv', only affects the
legend for the wind or variable in these arrays). Defaults to 15.}

\item{arr_units}{Units of 'varu' and 'varv', to be drawn in the legend. 
Takes 'm/s' by default.}

\item{arr_scale_shaft}{Parameter for the scale of the shaft of the arrows 
(which also depend on the number of figures and the arr_scale parameter). 
Defaults to 1.}

\item{arr_scale_shaft_angle}{Parameter for the scale of the angle of the 
shaft of the arrows (which also depend on the number of figure and the 
arr_scale parameter). Defaults to 1.}

\item{axelab}{Whether to draw longitude and latitude axes or not. 
TRUE by default.}

\item{labW}{Whether to label the longitude axis with a 'W' instead of minus 
for negative values. Defaults to FALSE.}

\item{intylat}{Interval between latitude ticks on y-axis, in degrees. 
Defaults to 20.}

\item{intxlon}{Interval between latitude ticks on x-axis, in degrees. 
Defaults to 20.}

\item{axes_tick_scale}{Scale factor for the tick lines along the longitude 
and latitude axes.}

\item{axes_label_scale}{Scale factor for the labels along the longitude 
and latitude axes.}

\item{drawleg}{Whether to plot a color bar (legend, key) or not. Defaults to 
TRUE. It is not possible to plot the colour bar if 'add = TRUE'. Use 
ColorBar() and the return values of PlotEquiMap() instead.}

\item{boxlim}{Limits of a box to be added to the plot, in degrees: 
c(x1, y1, x2, y2). A list with multiple box specifications can also be 
provided.}

\item{boxcol}{Colour of the box lines. A vector with a colour for each of 
the boxes is also accepted. Defaults to 'purple2'.}

\item{boxlwd}{Line width of the box lines. A vector with a line width for 
each of the boxes is also accepted. Defaults to 5.}

\item{margin_scale}{Scale factor for the margins around the map plot, with 
the format c(y1, x1, y2, x2). Defaults to rep(1, 4). If drawleg = TRUE, 
then margin_scale[1] is subtracted 1 unit.}

\item{title_scale}{Scale factor for the figure top title. Defaults to 1.}

\item{numbfig}{Number of figures in the layout the plot will be put into. 
A higher numbfig will result in narrower margins and smaller labels, 
axe labels, ticks, thinner lines, ... Defaults to 1.}

\item{fileout}{File where to save the plot. If not specified (default) a 
graphics device will pop up. Extensions allowed: eps/ps, jpeg, png, pdf, 
bmp and tiff.}

\item{width}{File width, in the units specified in the parameter size_units 
(inches by default). Takes 8 by default.}

\item{height}{File height, in the units specified in the parameter 
size_units (inches by default). Takes 5 by default.}

\item{size_units}{Units of the size of the device (file or window) to plot 
in. Inches ('in') by default. See ?Devices and the creator function of 
the corresponding device.}

\item{res}{Resolution of the device (file or window) to plot in. See 
?Devices and the creator function of the corresponding device.}

\item{\dots}{Arguments to be passed to the method. Only accepts the following 
graphical parameters:\cr
adj ann ask bg bty cex.sub cin col.axis col.lab col.main col.sub cra crt 
csi cxy err family fg font font.axis font.lab font.main font.sub lend 
lheight ljoin lmitre mex mfcol mfrow mfg mkh omd omi page pch pin plt 
pty smo srt tcl usr xaxp xaxs xaxt xlog xpd yaxp yaxs yaxt ylbias ylog \cr
For more information about the parameters see `par`.}
}
\value{
\item{brks}{
 Breaks used for colouring the map (and legend if drawleg = TRUE).
}
\item{cols}{
 Colours used for colouring the map (and legend if drawleg = TRUE). Always 
   of length length(brks) - 1.
}
\item{col_inf}{
 Colour used to draw the lower triangle end in the colour bar (NULL if not 
  drawn at all).
}
\item{col_sup}{
 Colour used to draw the upper triangle end in the colour bar (NULL if not 
  drawn at all).
}
}
\description{
Map longitude-latitude array (on a regular rectangular or gaussian grid) 
on a cylindrical equidistant latitude and longitude projection with coloured 
grid cells. Only the region for which data has been provided is displayed. 
A colour bar (legend) can be plotted and adjusted. It is possible to draw 
superimposed arrows, dots, symbols, contour lines and boxes. A number of 
options is provided to adjust the position, size and colour of the 
components. This plot function is compatible with figure layouts if colour 
bar is disabled.
}
\examples{
# See examples on Load() to understand the first lines in this example
 \dontrun{
data_path <- system.file('sample_data', package = 's2dv')
expA <- list(name = 'experiment', path = file.path(data_path,
            'model/$EXP_NAME$/$STORE_FREQ$_mean/$VAR_NAME$_3hourly',
            '$VAR_NAME$_$START_DATE$.nc'))
obsX <- list(name = 'observation', path = file.path(data_path,
            '$OBS_NAME$/$STORE_FREQ$_mean/$VAR_NAME$',
            '$VAR_NAME$_$YEAR$$MONTH$.nc'))

# Now we are ready to use Load().
startDates <- c('19851101', '19901101', '19951101', '20001101', '20051101')
sampleData <- Load('tos', list(expA), list(obsX), startDates,
                  leadtimemin = 1, leadtimemax = 4, output = 'lonlat',
                  latmin = 27, latmax = 48, lonmin = -12, lonmax = 40)
 }
 \dontshow{
startDates <- c('19851101', '19901101', '19951101', '20001101', '20051101')
sampleData <- s2dv:::.LoadSampleData('tos', c('experiment'),
                                               c('observation'), startDates,
                                               leadtimemin = 1,
                                               leadtimemax = 4,
                                               output = 'lonlat',
                                               latmin = 27, latmax = 48,
                                               lonmin = -12, lonmax = 40)
 }
PlotEquiMap(sampleData$mod[1, 1, 1, 1, , ], sampleData$lon, sampleData$lat, 
           toptitle = 'Predicted sea surface temperature for Nov 1960 from 1st Nov',
           sizetit = 0.5)
}

