% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CRPSS.R
\name{CRPSS}
\alias{CRPSS}
\title{Compute the Continuous Ranked Probability Skill Score}
\usage{
CRPSS(
  exp,
  obs,
  ref = NULL,
  time_dim = "sdate",
  memb_dim = "member",
  dat_dim = NULL,
  Fair = FALSE,
  clim.cross.val = TRUE,
  sig_method.type = "two.sided.approx",
  alpha = 0.05,
  ncores = NULL
)
}
\arguments{
\item{exp}{A named numerical array of the forecast with at least time 
dimension.}

\item{obs}{A named numerical array of the observation with at least time 
dimension. The dimensions must be the same as 'exp' except 'memb_dim'
and 'dat_dim'.}

\item{ref}{A named numerical array of the reference forecast data with at 
least time and member dimension. The dimensions must be the same as 'exp' 
except 'memb_dim' and 'dat_dim'. If there is only one reference dataset,
it should not have dataset dimension. If there is corresponding reference 
for each experiment, the dataset dimension must have the same length as in
'exp'. If 'ref' is NULL, the climatological forecast is used as reference 
forecast. To build the climatological forecast, the observed values along
the whole time period are used as different members for all time steps. The 
parameter 'clim.cross.val' controls whether to build it using 
cross-validation. The default value is NULL.}

\item{time_dim}{A character string indicating the name of the time dimension.
The default value is 'sdate'.}

\item{memb_dim}{A character string indicating the name of the member dimension
to compute the probabilities of the forecast and the reference forecast. The
default value is 'member'.}

\item{dat_dim}{A character string indicating the name of dataset dimension. 
The length of this dimension can be different between 'exp' and 'obs'. 
The default value is NULL.}

\item{Fair}{A logical indicating whether to compute the FairCRPSS (the 
potential CRPSS that the forecast would have with an infinite ensemble 
size). The default value is FALSE.}

\item{clim.cross.val}{A logical indicating whether to build the climatological
forecast in cross-validation (i.e. excluding the observed value of the time 
step when building the probabilistic distribution function for that 
particular time step). Only used if 'ref' is NULL. The default value is TRUE.}

\item{sig_method.type}{A character string indicating the test type of the
significance method. Check \code{RandomWalkTest()} parameter 
\code{test.type} for details. The default is 'two.sided.approx', which is 
the default of \code{RandomWalkTest()}.}

\item{alpha}{A numeric of the significance level to be used in the statistical
significance test. The default value is 0.05.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
\item{$crpss}{
 A numerical array of the CRPSS with dimensions c(nexp, nobs, the rest 
 dimensions of 'exp' except 'time_dim' and 'memb_dim' dimensions). nexp is 
 the number of experiment (i.e., dat_dim in exp), and nobs is the number of 
 observation (i.e., dat_dim in obs). If 'dat_dim' is NULL, nexp and nobs are
 omitted.
}
\item{$sign}{
 A logical array of the statistical significance of the CRPSS with the same 
 dimensions as $crpss.
}
}
\description{
The Continuous Ranked Probability Skill Score (CRPSS; Wilks, 2011) is the 
skill score based on the Continuous Ranked Probability Score (CRPS; Wilks, 
2011). It can be used to assess whether a forecast presents an improvement or 
worsening with respect to a reference forecast. The CRPSS ranges between minus 
infinite and 1. If the CRPSS is positive, it indicates that the forecast has 
higher skill than the reference forecast, while a negative value means that it
has a lower skill. Examples of reference forecasts are the climatological 
forecast, persistence, a previous model version, or another model. It is 
computed as 'CRPSS = 1 - CRPS_exp / CRPS_ref. The statistical significance is 
obtained based on a Random Walk test at the specified confidence level 
(DelSole and Tippett, 2016).
}
\examples{
exp <- array(rnorm(1000), dim = c(lat = 3, lon = 2, member = 10, sdate = 50))
obs <- array(rnorm(1000), dim = c(lat = 3, lon = 2, sdate = 50))
ref <- array(rnorm(1000), dim = c(lat = 3, lon = 2, member = 10, sdate = 50))
res <- CRPSS(exp = exp, obs = obs) ## climatology as reference forecast
res <- CRPSS(exp = exp, obs = obs, ref = ref) ## ref as reference forecast

}
\references{
Wilks, 2011; https://doi.org/10.1016/B978-0-12-385022-5.00008-7
DelSole and Tippett, 2016; https://doi.org/10.1175/MWR-D-15-0218.1
}
