% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sample_fraction}
\alias{sample_fraction}
\alias{sample_number}
\title{Sampling functions}
\usage{
sample_fraction(size, replace = FALSE, weight = NULL, groupVars = NULL)

sample_number(size, replace = FALSE, weight = NULL, groupVars = NULL)
}
\arguments{
\item{size}{For \code{sample_n}, the number of rows to select.
For \code{sample_frac}, the fraction of rows to select.
If \code{tbl} is grouped, \code{size} applies to each group.}

\item{replace}{Sample with or without replacement?}

\item{weight}{Sampling weights. This expression is evaluated in the
context of the data frame. It must return a vector of non-negative
numbers the same length as the input. Weights are automatically
standardised to sum to 1.}

\item{groupVars}{character with names of variables to be used for grouping.}
}
\description{
This function is intended to be used with \code{\link{sim_sample}} and not interactively. This is a wrapper around \link[dplyr]{sample_frac} and \link[dplyr]{sample_n}.
}
\examples{
sim_base_lm() \%>\% sim_sample(sample_number(5))
sim_base_lm() \%>\% sim_sample(sample_fraction(0.5))
}

