% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SaemixModel.R
\docType{class}
\name{SaemixModel-class}
\alias{SaemixModel-class}
\alias{SaemixModel}
\alias{[<-,SaemixModel-method}
\alias{print,SaemixModel}
\alias{showall,SaemixModel}
\alias{show,SaemixModel}
\alias{summary,SaemixModel}
\title{Class "SaemixModel"}
\description{
An object of the SaemixModel class, representing a nonlinear mixed-effect
model structure, used by the SAEM algorithm.
}
\section{Objects from the Class}{
 
An object of the SaemixModel class can be created by using the function \code{\link{saemixModel}} and contain the following slots:
  \describe{
    \item{\code{model}:}{Object of class \code{"function"}: name of the function used to get predictions from the model (see the User Guide and the online examples for the format and what this function should return).}
    \item{\code{description}:}{Object of class \code{"character"}: an optional text description of the model}
    \item{\code{psi0}:}{Object of class \code{"matrix"}: a matrix with named columns containing the initial estimates for the parameters in the model (first line) and for the covariate effects (second and subsequent lines, optional). The number of columns should be equal to the number of parameters in the model.}
    \item{\code{transform.par}:}{Object of class \code{"numeric"}: vector giving the distribution for each model parameter (0: normal, 1: log-normal, 2: logit, 3: probit). Its length should be equal to the number of parameters in the model.}
    \item{\code{fixed.estim}:}{Object of class \code{"numeric"}: for each parameter, 0 if the parameter is fixed and 1 if it should be estimated. Defaults to a vector of 1 (all parameters are estimated). Its length should be equal to the number of parameters in the model.}
    \item{\code{error.model}:}{Object of class \code{"character"}: name of the error model. Valid choices are "constant" (default), "proportional" and "combined" (see equations in User Guide)}
    \item{\code{covariate.model}:}{Object of class \code{"matrix"}: a matrix of 0's and 1's, with a 1 indicating that a parameter-covariate relationship is included in the model (and an associated fixed effect will be estimated). The nmuber of columns should be equal to the number of parameters in the model and the number of rows to the number of covariates.}
    \item{\code{covariance.model}:}{Object of class \code{"matrix"}: a matrix f 0's and 1's giving the structure of the variance-covariance matrix. Defaults to the Identity matrix (diagonal IIV, no correlations between parameters)}
    \item{\code{omega.init}:}{Object of class \code{"matrix"}: a matrix giving the initial estimate for the variance-covariance matrix}
    \item{\code{error.init}:}{Object of class \code{"numeric"}: a vector giving the initial estimate for the parameters of the residual error}
  }
  Additional elements are added to the model object after a call to \code{saemix} and are used in the algorithm.
}

\section{Methods}{

  \describe{
    \item{[<-}{\code{signature(x = "SaemixModel")}: replace elements of object}
    \item{[}{\code{signature(x = "SaemixModel")}: access elements of object}
    \item{initialize}{\code{signature(.Object = "SaemixModel")}: internal function to initialise object, not to be used}
    \item{plot}{\code{signature(x = "SaemixModel")}: plot predictions from the model}
    \item{print}{\code{signature(x = "SaemixModel")}: prints details about the object (more extensive than show)}
    \item{showall}{\code{signature(object = "SaemixModel")}: shows all the elements in the object}
    \item{show}{\code{signature(object = "SaemixModel")}: prints details about the object}
	 }
}

\examples{

showClass("SaemixModel")

}
\references{
Comets  E, Lavenu A, Lavielle M. Parameter estimation in nonlinear mixed effect models using saemix, an R implementation of the SAEM algorithm. Journal of Statistical Software 80, 3 (2017), 1-41.

Kuhn E, Lavielle M. Maximum likelihood estimation in nonlinear mixed effects models. Computational Statistics and Data Analysis 49, 4 (2005), 1020-1038.

Comets E, Lavenu A, Lavielle M. SAEMIX, an R version of the SAEM algorithm. 20th meeting of the 
Population Approach Group in Europe, Athens, Greece (2011), Abstr 2173.
}
\seealso{
\code{\link{SaemixData}} \code{\link{SaemixObject}} \code{\link{saemixControl}} \code{\link{saemix}}
\code{\link{plot.saemix}}
}
\author{
Emmanuelle Comets \email{emmanuelle.comets@inserm.fr}

Audrey Lavenu

Marc Lavielle.
}
\keyword{classes}
