% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk-operation.R
\name{sf_upload_complete_bulk}
\alias{sf_upload_complete_bulk}
\title{Signal Upload Complete to Bulk API Job}
\usage{
sf_upload_complete_bulk(job_id, api_type = c("Bulk 2.0"), verbose = FALSE)
}
\arguments{
\item{job_id}{character; the Salesforce Id assigned to a submitted job as 
returned by \link{sf_create_job_bulk}}

\item{api_type}{character; one of "REST", "SOAP", or "Bulk" indicating 
which API to use when making the request}

\item{verbose}{logical; do you want informative messages?}
}
\value{
A \code{list} of parameters defining the job after signaling a completed upload
}
\description{
This function signals that uploads are complete to a Job in the Salesforce Bulk API
}
\note{
This function is typically not used directly. It is used in \code{sf_create_batches_bulk()} 
right after submitting the batches to signal to Salesforce that the batches should 
no longer be queued.
}
\examples{
\dontrun{
upload_info <- sf_upload_complete_bulk(job_id=job_info$id)
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/}
}
