% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-org.R
\name{sf_get_updated}
\alias{sf_get_updated}
\title{Get Updated Records from a Timeframe}
\usage{
sf_get_updated(object_name, start, end, verbose = FALSE)
}
\arguments{
\item{object_name}{character; the name of one Salesforce objects that the 
function is operating against (e.g. "Account", "Contact", "CustomObject__c")}

\item{start}{\code{date} or \code{datetime}; starting datetime of the timespan 
for which to retrieve the data.}

\item{end}{\code{date} or \code{datetime}; ending datetime of the timespan for
which to retrieve the data.}

\item{verbose}{logical; do you want informative messages?}
}
\description{
Retrieves the list of individual records that have been inserted or updated 
within the given timespan in the specified object.
}
\note{
This API ignores the seconds portion of the supplied datetime values.
}
\examples{
\dontrun{
# get all updated Contact records from midnight until now
updated_recs <- sf_get_updated("Contact", Sys.Date(), Sys.time())
}
}
