% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk-operation.R
\name{sf_upload_complete_bulk}
\alias{sf_upload_complete_bulk}
\title{Signal Upload Complete to Bulk API Job}
\usage{
sf_upload_complete_bulk(job_id, api_type = c("Bulk 2.0"), verbose = FALSE)
}
\arguments{
\item{job_id}{\code{character}; the Salesforce Id assigned to a submitted job as
returned by \link{sf_create_job_bulk}. It will start with \code{"750"}.}

\item{api_type}{\code{character}; one of \code{"REST"}, \code{"SOAP"},
\code{"Bulk 1.0"}, or \code{"Bulk 2.0"} indicating which API to use when
making the request.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
A \code{list} of parameters defining the job after signaling a completed upload
}
\description{
This function signals that uploads are complete to a Job in the Salesforce Bulk API
}
\note{
This function is typically not used directly. It is used in \code{sf_create_batches_bulk()}
right after submitting the batches to signal to Salesforce that the batches should
no longer be queued.
}
\examples{
\dontrun{
upload_info <- sf_upload_complete_bulk(job_id=job_info$id)
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/}
}
