% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-org.R
\name{sf_undelete}
\alias{sf_undelete}
\title{Undelete Records}
\usage{
sf_undelete(
  ids,
  api_type = c("SOAP"),
  control = list(...),
  ...,
  verbose = FALSE
)
}
\arguments{
\item{ids}{\code{vector}, \code{matrix}, \code{data.frame}, or
\code{tbl_df}; if not a vector, there must be a column called Id (case-insensitive)
that can be passed in the request}

\item{api_type}{\code{character}; one of \code{"REST"}, \code{"SOAP"},
\code{"Bulk 1.0"}, or \code{"Bulk 2.0"} indicating which API to use when
making the request.}

\item{control}{\code{list}; a list of parameters for controlling the behavior of
the API call being used. For more information of what parameters are available
look at the documentation for \code{\link{sf_control}}.}

\item{...}{arguments passed to \code{\link{sf_control}}}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
\code{tbl_df} of records with success indicator
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Undeletes records from the Recycle Bin.
}
\note{
Because the SOAP and REST calls chunk data into batches of 200 records
the AllOrNoneHeader will only apply to the success or failure of every batch
of records and not all records submitted to the function.
}
\examples{
\dontrun{
new_contact <- c(FirstName = "Test", LastName = "Contact")
new_records <- sf_create(new_contact, object_name = "Contact")
delete <- sf_delete(new_records$id[1],
                    AllOrNoneHeader = list(allOrNone = TRUE))
is_deleted <- sf_query(sprintf("SELECT Id, IsDeleted FROM Contact WHERE Id='\%s'",
                       new_records$id[1]), 
                       queryall = TRUE)
undelete <- sf_undelete(new_records$id[1])
is_not_deleted <- sf_query(sprintf("SELECT Id, IsDeleted FROM Contact WHERE Id='\%s'",
                           new_records$id[1]))
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api.meta/api/sforce_api_calls_undelete.htm}
}
