% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{sfn_metrics}
\alias{sfn_metrics}
\title{Metrics summary function}
\usage{
sfn_metrics(sfn_data, period, .funs, solar, interval = c("general",
  "predawn", "midday", "night", "daylight"), int_start = NULL,
  int_end = NULL, ...)
}
\arguments{
\item{sfn_data}{\code{\link{sfn_data}} or \code{\link{sfn_data_multi}} object
to obtain the metrics from}

\item{period}{Time period to aggregate data by. See period section for an
explanation about the periods ('1 day', '1 month', '1 year', ...)}

\item{.funs}{List of function calls to summarise the data by, see .funs
section for more details.}

\item{solar}{Logical indicating if the solarTIMESTAMP must be used instead of
the site local TIMESTAMP. Default to TRUE (use solarTIMESTAMP).}

\item{interval}{Character vector indicating if the metrics must be filtered
by an special hour interval. See Interval section in details.}

\item{int_start}{Integer value indicating the starting hour of the special
interval in 24h format. See Interval section in details.}

\item{int_end}{Integer value indicating the ending hour of the special
interval in 24h format. See Interval section in details.}

\item{...}{optional arguments to pass to methods used
(i.e. .collapse_timestamp or summarise funs extra arguments)}
}
\value{
For \code{\link{sfn_data}} objects, a list of tbl_df objects
  with the following structure:
  \itemize{
    \item{$sapf: metrics for the sapflow data}
    \item{$env: metrics for the environmental data}
  }

  For \code{\link{sfn_data_multi}} objects, a list of lists of tbl_df objects
  with the metrics for each site:
  \itemize{
    \item{$SITE_CODE
      \itemize{
        \item{$sapf: metrics for the sapflow data}
        \item{$env: metrics for the environmental data}
      }
    }
    \item{$NEXT_SITE_CODE...}
  }
}
\description{
Generate metrics from a site/s data for the period indicated
}
\section{Period}{

\code{period} argument is used by internal function
\code{\link{.collapse_timestamp}} and it can be stated in two ways:
\itemize{
  \item{\emph{frequency period} format: "1 day", "7 days", "1 month", "3 hours"}
  \item{As a \emph{custom function}. This will be the name of a function,
  without quotes, that accepts as the first argument the timestamp to collapse.
  The result of the function must be a vector of collapsed TIMESTAMPs of the
  same length than the original TIMESTAMP which will be used to group by and
  summarise the data. Additional arguments to this function, if needed, can
  be passed in the \code{...} argument.}
}
\code{\link{.collapse_timestamp}} also accepts the \code{side} argument to
collapse by the starting timestamp or the ending timestamp of each group. This
can be supplied in the \code{...} argument.
}

\section{.funs}{

\code{.funs} argument uses the same method as the \code{.funs} argument in the
\code{\link[dplyr]{summarise_all}} function of \code{dplyr} package. Basically
it accepts a list of function calls generated by list(). If you want to pass
on a custom function you can specify it here. See details in
\code{\link{summarise_by_period}} for more complex summarising functions
declaration.
}

\section{Interval}{

Previously to the metrics summary, data can be filtered by an special
interval (i.e. predawn or nightly). This filtering can be specified with the
 \code{interval} argument as this:
\itemize{
  \item{\code{"general"} (default). No special interval is used, and metrics
        are performed with all the data}.
  \item{\code{"predawn"}. Data is filtered for predawn interval. In this case
        \code{int_start} and \code{int_end} must be specified as 24h value}
  \item{\code{"midday"}. Data is filtered for midday interval. In this case
        \code{int_start} and \code{int_end} must be specified as 24h value}
  \item{\code{"night"}. Data is filtered for night interval. In this case
        \code{int_start} and \code{int_end} must be specified as 24h value}
  \item{\code{"daylight"}. Data is filtered for daylight interval. In this case
        \code{int_start} and \code{int_end} must be specified as 24h value}
}
}

\examples{
library(dplyr)

### general metrics
## sfn_data
data('ARG_TRE', package = 'sapfluxnetr')
ARG_TRE_metrics <- sfn_metrics(
  ARG_TRE,
  period = '7 days',
  .funs = list(~ mean(., na.rm = TRUE), ~ sd(., na.rm = TRUE), ~ n()),
  solar = FALSE,
  interval = 'general'
)

str(ARG_TRE_metrics)
ARG_TRE_metrics[['sapf']]
ARG_TRE_metrics[['env']]

## sfn_data_multi
\donttest{
data('ARG_MAZ', package = 'sapfluxnetr')
data('AUS_CAN_ST2_MIX', package = 'sapfluxnetr')
multi_sfn <- sfn_data_multi(ARG_TRE, ARG_MAZ, AUS_CAN_ST2_MIX)

multi_metrics <- sfn_metrics(
  multi_sfn,
  period = '7 days',
  .funs = list(~ mean(., na.rm = TRUE), ~ sd(., na.rm = TRUE), ~ n()),
  solar = FALSE,
  interval = 'general'
)

str(multi_metrics)

multi_metrics[['ARG_TRE']][['sapf']]
}

### midday metrics
ARG_TRE_midday <- sfn_metrics(
  ARG_TRE,
  period = '1 day',
  .funs = list(~ mean(., na.rm = TRUE), ~ sd(., na.rm = TRUE), ~ n()),
  solar = TRUE,
  interval = 'midday', int_start = 11, int_end = 13
)

str(ARG_TRE_midday)
ARG_TRE_midday[['sapf']]

}
\seealso{
Other metrics: \code{\link{metrics}}
}
\concept{metrics}
