## Do not edit this file manually.
## It has been automatically generated from *.org sources.

expand_ar <- function(ar, sar, s){
    x <- polynom(c(0,1))
    phi <- polynom(c(1, -ar))
    sphi <- polynom(c(1, -sar))(x^s)

    coef(phi * sphi)  
}

poly_x     <- polynom(c(0,1))
poly_delta <- polynom(c(1, -1)) # = 1 - poly_x

.sarima_env <- function(){
    .process_fixed <- function(x, fixed = NULL){
        if(is.null(x))
            stop("'x' must have a value here")
        xlen <- length(x)
        
        if(is.null(fixed))
            rep(FALSE, xlen)
        else if(isTRUE(fixed))
            rep(TRUE, xlen)
        else if(is.logical(fixed)){
            if(length(fixed) != xlen)
                stop("if 'fixed' is logical it must be of the same length as the order")
            fixed
        }else if(is.numeric(fixed)){
            ## indices of fixed elements, must be whole numbers
            if(!is.integer(fixed) && any(round(fixed) != fixed))
                stop("if numeric, 'fixed' must contain integer numbers")
            if(any(fixed <= 0) || any(fixed > xlen))
                stop("if numeric, 'fixed' must contain integers between 1 and 'order'")
            res <- rep(FALSE, xlen)
            res[fixed] <- TRUE
            res # needed since 'res[fixed] <- value'  returns the rhs
        }else{
            stop("unsupported type of 'fixed'")
        }
    }

    ## currently essentially identical to .process_fixed()
    .process_atanh.tr <- function(x, transf = NULL){
        if(is.null(x))
            stop("'x' must have a value here")
        xlen <- length(x)
        
        if(is.null(transf))
            rep(FALSE, xlen)
        else if(isTRUE(transf))
            rep(TRUE, xlen)
        else if(is.logical(transf)){
            if(length(transf) == 1)
                rep(transf, xlen)
            else if(length(transf) == xlen)
                transf
            else
                stop("if 'transf' is logical it must be of the same length as the order")
        }else if(is.numeric(transf)){
            ## indices of transf elements, must be whole numbers
            if(!is.integer(transf) && any(round(transf) != transf))
                stop("if numeric, 'transf' must contain integer numbers")
            if(any(transf <= 0) || any(transf > xlen))
                stop("if numeric, 'transf' must contain integers between 1 and 'order'")
            res <- rep(FALSE, xlen)
            res[transf] <- TRUE
            res
        }else{
            stop("unsupported type of 'transf'")
        }
    }

    ## parcor
    ## roots ?
    ## fixed
    ## nonfixed
    ## convention ?
    ## dispname ?
    ##
    ## based on co_ar() in sarima() and ar() in .sarima_env
    .set_coef <- function(order, coef = NULL, fixed = NULL, nonfixed = NULL,
                          atanh.tr = NULL, ...){
        wrk <- NULL
        coef.type <- "coef"  # todo: any subtleties?
        if(!is.null(order))
            wrk <- rep(NA_real_, order)
    
        if(!missing(coef) && !is.null(coef)){
            if(is.null(wrk))
                wrk <- coef
            else{
                    # todo: is it reasonable to allow a smaller length, so that coef's from
                    #       lower order fits can be used as initial values more easily?
                if(length(coef) != length(wrk))
                    stop("if given, 'coef' must have length equal to 'order'")
                wrk[1:length(coef)] <- coef
            }
        }
    
        a <- .process_fixed(wrk, fixed)
        b <- .process_atanh.tr(wrk, atanh.tr)

        if(!missing(nonfixed) || !is.null(nonfixed)){
                                # declare non-fixed some coef's previously marked as fixed
            b <- .process_fixed(wrk, nonfixed)
                # !b is FALSE only for the elements declared nonfixed by 'nonfixed', so this
                # !will transfer this to 'a', leaving others as they are (fixed or nonfixed)
            a <- a & !b
        }

        res <- wrk
        attr(res, "fixed") <- a
        attr(res, "atanh.tr") <- b

        ## store addtional info, e.g. parcor, negate
        dots <- list(...)
        for(at in names(dots))
            attr(res, at) <- dots[[at]]
        
        res
    }

    ar <- function(p = 0, ar, sign = "-", atanh.tr = TRUE, ...){
        ## NOTE: do not name p and ar in the call for flexibility:
        coef <- .set_coef(p, ar, sign = sign, dispname = "ar", atanh.tr = atanh.tr, ...)
        list(name = "ar", p = p, coef = coef)    # TODO: remove 'p' from the return value?
    }

    ma <- function(q = 0, ma, sign = "+", atanh.tr = TRUE, ...){
        coef <- .set_coef(q, ma, sign = sign, dispname = "ma", atanh.tr = atanh.tr, ...)
        list(name = "ma", q = q, coef = coef)
    }

    s <- function(...){
        ## TODO: for now 'm' of length 1
        dots <- c(...)
        if(length(dots) != 1)
            stop("currently only one argument is supported")
        p <- dots[1] - 1
        coef <- .set_coef(p, rep(1, p), sign = "+", fixed = TRUE, operator = TRUE, dispname = "s")
        list(name = "s", p = p, coef = coef)
    }
    
    ## unit roots
    i <- function(d, ...){
        ## TODO: this needs special method later!
        coef <- .set_coef(1, 1, sign = "-", fixed = TRUE, d = d, operator = TRUE,
                          dispname = "i", ...)
        list(name = "i", d = d, p = 1, coef = coef)
    }

    u <- function(u, fixed = TRUE, operator = all(fixed), ...){
                     # u may be a list to accommodate mixed complex and real values, probably
                     # not a good idea. Do not convert to use Recall() if u is 'list'
        f <- function(x){
            if(is.complex(x))
                -2*cos(Arg(x))    # equivalently: -2*Re(x), but this assumes that Mod(x)=1
            else -2 * cospi(2*x) # x is a fraction of 2pi
        }
        co <- sapply(u, f) 
        coef <- lapply(co, function(x) .set_coef(2, c(x, 1), sign = "+", fixed = fixed,
                                                 operator = operator, dispname = "su") )
        list(name = "u", u = u, coef = coef)
    }
    
    su <- function(s, h){
                      # TODO: check that elements of h are among 1,2, ..., s/2 (excluding s/s
                      #       if s is even) coef is a list here!
        coef <- lapply(h, function(x)
                              .set_coef(2, c(- 2 * cospi(2*x/s), 1),
                                        sign = "+", fixed = TRUE, operator = TRUE,
                                        dispname = "su", su.nseasons = s, su.harmonic = x) )
        list(name = "su", s = s, u = h, coef = coef) 
    }

    ## spec for unit roots to be estimated (unless fixed)
    ## TODO: require p >= 2 in "uar"?
    uar <- function(p = 0, parcor, sign = "-", atanh.tr = TRUE, fixed = NULL, ...){
        if(is.null(fixed)){
            fixed <- rep(FALSE, p)
            if(p > 0)
                fixed[p] <- TRUE
        }
                            # NOTE: do not name p and parcor in the call for flexibility
        coef <- .set_coef(p, parcor, sign = sign, dispname = "uar", atanh.tr = atanh.tr,
                          fixed = fixed, ...)
                                                
        list(name = "uar", p = p, coef = coef)   # TODO: rename 'coef' to 'parcor' here?
    }
    

    ## seasonal

    sar <- function(s, p = 0, ar, sign = "-", atanh.tr = TRUE, ...){
                  # NOTE: do not name p and ar in the call for flexibility
        coef <- .set_coef(p, ar, sign = sign, nseasons = s, dispname = "sar",
                          atanh.tr = atanh.tr, ...)
        list(name = "sar", s = s, p = p, coef = coef)        # TODO: remove 's' and 'p'?
    }
    
    sma <- function(s, q = 0, ma, sign = "+", atanh.tr = TRUE, ...){
        coef <- .set_coef(q, ma, sign = sign, nseasons = s, dispname = "sma",
                          atanh.tr = atanh.tr, ...)
        list(name = "sma", s = s, q = q, coef = coef)
    }

    ss <- function(s, ...){
        ## TODO: for now 'm' of length 1
        dots <- c(...)
        if(length(dots) != 1)
            stop("currently only one argument is supported")
        p <- dots[1] - 1
        coef <- .set_coef(p, rep(1, p), sign = "+", nseasons = s, fixed = TRUE,
                          operator = TRUE, dispname = "ss")
        list(name = "ss", s = s, p = p, coef = coef)
    }
    
    ## seasonal unit roots
    si <- function(s, d, ...){
        coef <- .set_coef(1, 1, sign = "-", nseasons = s, fixed = TRUE,
                          operator = TRUE, dispname = "si", ...)
        list(name = "si", s = s, d = d, coef = coef)
    }

    su <- function(s, h){    # TODO: check that elements of h are among 1,2, ..., s/2
                             # (excluding s/s if s is even) coef is a list here!
        coef <- lapply(h, function(x)
                              .set_coef(2, c(- 2 * cospi(2*x/s), 1), sign = "+",
                                        fixed = TRUE, operator = TRUE, dispname = "su",
                                        su.nseasons = s, su.harmonic = x) )
        list(name = "su", s = s, u = h, coef = coef) 
    }

    ## !!! NOTE: this assumes that the user facing objects do not start with dot!
    .specials <- ls()

    .sarima_descr <- list()
    class(.sarima_descr) <- "sarimadescr"
    
    environment()
}# end .of sarima_env()

SARIMA <- function(formula){
    e <- .sarima_env()
    parent.env(e) <- environment(formula)
    
                        # keep.order keeps the order for the data frame.
                        # The order in attribute "specials" is not affected by this.
    te <- terms(formula, specials = e$.specials, keep.order = TRUE)

                        # tmp <- (attr(te, "variables")[[3]]); eval(tmp, envir = e)
    termvars <- attr(te, "variables")
    sp <- attr(te, "specials")
    res <- list()

    indices <- lapply(names(sp), 
                      function(nam){ 
                          ind <- sp[[nam]]
                          if(is.null(ind))
                              return(integer(0))
                          names(ind) <- rep(nam, length(ind))
                          ind
                      }
                      )

    indices <- sort(unlist(indices))
    nams <- names(indices)
    
    indices <- indices + 1
    res <- vector("list", length = length(indices))
    names(res) <- nams
    for(i in seq_along(indices)){
        ## evaluate the terms (like ar(), ma(), etc.)
        res[[i]] <- eval(termvars[[indices[i]]], envir = e)
    }

    res
}

trendMaker <- function(formula, data = NULL, time = NULL){
    if(is.null(data))
        data.env <- new.env(hash = FALSE, parent = environment(formula))
    else{ 
        stopifnot(is.environment(data))
        data.env <- data
    }
   
    environment(formula) <- data.env
    data.env$formula <- formula

                 # data.env$.t.orig can be used to detect if 't' is not the original one
    data.env$.t.orig <- data.env$t <- time

    .t.orig <- "dummy for R CMD check; .t.orig is needed in dataenv, as set above"

    data.env$.p <- function(degree){
        if(identical(t, .t.orig))
            res <- poly(t, degree = degree, simple = TRUE) 
        else{
            wrk <- poly(.t.orig, degree = degree, simple = FALSE)
            res <- predict(wrk, newdata = t) 
        }
        colnames(res) <- paste0("ortht", seq_len(degree))
        res
    }
    environment(data.env$.p) <- data.env

        # cs <- function(s, freq){
        #     ## s - scalar; k in 1,2,...,[s/2]
        #     wrk <- lapply(freq, function(k) cbind(cospi(2*time*k/s), sinpi(2*time*k/s)))
        #     res <- do.call("cbind", wrk)
        #     
        #         # colnames(res) <-
        #         #     unlist(lapply(freq, function(x) paste0(c("cos", "sin"), x, ".", s)))
        #     res
        # }
    data.env$.cs <- function(s, k){
        ## s - scalar; k in 1,2,...,[s/2]
        ## TODO: for now assume scalar k too:
        res <- if(length(k) == 1){  # cbind(cospi(2*t*k/s), sinpi(2*t*k/s))
                   structure(c(cospi(2*t*k/s), sinpi(2*t*k/s)), 
                               dim = c(length(t), 2),
                               .Dimnames =  list(NULL, paste0(c("c", "s"), s, ".", k) ))
              }else if(length(k) > 1){
                  wrk <- lapply(k, function(x) cbind(cospi(2*t*x/s), sinpi(2*t*x/s)) )
                  wrk <- do.call("cbind", wrk)
                  colnames(wrk) <- paste0(c("c", "s"), s, ".", rep(k, each = 2) )
                  wrk
              }else
                  stop("'k' must have positive length")

            # TODO: put names, keeping them short (Hm... 7*48 ...)
            # TODO: colnames(res) <- paste0(c("cos", "sin"), k, ".", s)
        res
    }
    environment(data.env$.cs) <- data.env

    ## TODO: test thoroughly
    data.env$.B <- function(x, lags){
        flags <- t > 0
        t.pos <- t[flags]
        t.neg <- t[!flags]

        if(any(flags)){
            ## 15/01/2018 - krapka to accept matrix x
            if(is.matrix(x)){ ## TODO: maybe check also if ncol(1) ? 
                res <- matrix(NA_real_, nrow = length(t), ncol = ncol(x) * length(lags))
                nc.x <- ncol(x)
                curcols <- seq_len(nc.x)
                for(i in seq_along(lags)){
                    lag <- lags[i]
                    res[t - lag > 0, curcols] <- x[pmax(t - lag, 0), ]
                    curcols <- curcols + nc.x 
                }
                ## TODO: don't know why there are no names in this case.
                xnam <- deparse(substitute(x))
                ## TODO: check for "[" or "$" in xnam and adjust the names accordingly
                colnames(res) <- paste0("L(", xnam, rep(seq_len(ncol(x)), length(lags)),
                                        ", ", rep(lags, each = ncol(x)), ")") 
            }else{
                res <- matrix(NA_real_, nrow = length(t), ncol = length(lags))
                for(i in seq_along(lags)){
                    lag <- lags[i]
                    res[t - lag > 0, i] <- x[pmax(t - lag, 0)]
                }
            }
        }
        res
    }
    environment(data.env$.B) <- data.env

    res <- function(index){
        if(missing(index)){# TODO: napravi tova s na.action to avoid losing NA's
            
                # 15/01/2018 was: model.matrix(formula)
                #     changing to use model.frame since we need to keep rows with NA's
                #     and it seems that model.matrix() doesn't have this argument.
                #     TODO: !!! However, model.frame doesn't contain the intercept,
                #               if present! So, it gets lost here.
                #
                # OK, sorted, this is a reply by Brian Ripley to a similar question
                # (TODO: take note also of the user defined function for na.action.):
                #
                #     Yes, but it uses options("na.action"), so you could set that.
                #     Better, call model.frame then model.matrix, something like
                # 
                #     stratmat <- model.matrix(myformula, 
                #                   model.frame(myformula,mydata, na.action = function(x) x))
                # 
                #     ?model.matrix does tell you the second argument should be the result
                #     of model.frame, which is a pretty strong hint.
                 
            res <- model.matrix(formula, model.frame(formula, na.action = NULL))
        }else{
            t.old <- t
            t <<- index
            ## TODO: krapka!!!! - drop the lhs since the length of t is now diferent.

            ## TODO: this will do if there is only time trend but exogeneous vars need
            ##       further work also, will this work if there is only intercept?  Maybe
            ##       should put a dummy variable on the left?
            formula <- formula(Formula::Formula(formula), lhs = FALSE, rhs = 1)
            txt <- paste0(".dummy", paste0(as.character(formula), collapse = ""))
            formula <- as.formula(txt, env = environment(formula))
                # 15/01/2018 - changing to use model.frame since we need to keep rows with
                #     NA's and it seems that model.matrix() doesn't have this argument.
                #     (see also Ripley's remark in  the 'if' clause above)
                # res <- model.matrix(formula, data = data.frame(.dummy = t))
                # res <- as.matrix(res[ , -1])
            res <- model.frame(formula, data = data.frame(.dummy = t), na.action = NULL)
            res <- model.matrix(formula, res)
            t <<- t.old
            res
        }
    }
    environment(res) <- data.env
    res
}

.cat_u_delta <- function(x){
    f <- function(poly){
        s <- environment(poly)$nseasons
        if(!is.null(s)) 
            poly <- poly(poly_x^s)
        if(all(coef(poly) == 1) && (deg <- length(coef(poly)) - 1) > 3)
            res <- paste0("1 + B + ... + B^", deg)
        else
            res <- as.character(poly, "B")
        d <- environment(poly)$d
        if(is.null(d) || d == 1)
            paste0("(", res, ")")
        else
            paste0("(", res, ")^", d)
    }
    paste0(sapply(x, f), collapse = "")
}

print.Sarima <-
    function (x, digits = max(3L, getOption("digits") - 3L), se = TRUE, ...){
    cat("*Sarima model*")
    cat("\nCall:", deparse(x$call, width.cutoff = 75L), "", sep = "\n")
        # cat("\nTrend: \n\t")
        # print(Fo.trend, FALSE)
        # cat("\nSARIMA specification: \n\t")
        # print(Fo.sarima, FALSE)
    delta <- x$internal$delta
    if(length(delta) > 0){
        cat("Unit root terms:\n", "    ")
        cat(.cat_u_delta(x$internal$delta_poly), sep = "")
        cat("\n\n")
    }

    if (length(x$coef)) {
        cat("Coefficients:\n")
        coef <- round(x$coef, digits = digits)
        ## use NROW as if all coefs are fixed there are no var.coef's
        if (se && NROW(x$var.coef)) {
            ses <- rep.int(0, length(coef))
            ses[x$mask] <- round(sqrt(diag(x$var.coef)), digits = digits)
            coef <- matrix(coef, 1L, dimnames = list(NULL, names(coef)))
            coef <- rbind(coef, s.e. = ses)
        }
        print.default(coef, print.gap = 2)
    }
    cm <- x$call$method
    if(is.null(cm) || cm != "CSS")
        cat("\nsigma^2 estimated as ", format(x$sigma2, digits = digits),
            ":  log likelihood = ", format(round(x$loglik, 2L)),
            ",  aic = ", format(round(x$aic, 2L)), "\n", sep = "")
    else
        cat("\nsigma^2 estimated as ",
            format(x$sigma2, digits = digits),
            ":  part log likelihood = ", format(round(x$loglik,2)),
            "\n", sep = "")
    invisible(x)
}

.Sarima_fixed <- function(x) x$internal$fixed
.capture_fo <- function(x) if(is.numeric(x)) x  else capture.output(print(x, FALSE))
.Fo.xreg <- function(x) x$internal$Fo.xreg
.Fo.sarima <- function(x) x$internal$Fo.sarima
.Fo.regx <- function(x) if(is.null(res <- x$internal$Fo.regx)) 0 else res

summary.Sarima <- function(object, ...){
    ## follow the 'lm' tradition
    cat("\nCall:\n", paste(deparse(object$call), sep = "\n", collapse = "\n"), 
        "\n\n", sep = "")

    ## TODO: these need more stable implementation, probably should be in the object.
               # object$call[[2]][[3]][[1]] is '|'
        # Fo.xreg   <- object$formula[[3]][[2]] # or object$call[[2]][[3]][[2]]
        # Fo.sarima <- object$formula[[3]][[3]]
        # Fo.regx   <- if(length(object$formula[[3]]) > 3) object$formula[[3]][[4]] else 0

    Fo.xreg   <- .Fo.xreg  (object)
    Fo.sarima <- .Fo.sarima(object)
    Fo.regx   <- .Fo.regx  (object)

    xfo      <- .capture_fo(Fo.xreg)
    fosarima <- .capture_fo(Fo.sarima)
    fox      <- .capture_fo(Fo.regx)
      
    cat("Model:  Y_t - xreg_t is SarimaX\n")
    cat("  xreg:   ", xfo, "\n")
    cat("  sarima: ", fosarima, "\n")
    cat("  regx:   ", fox, "\n")
    cat("\n")

    delta <- object$internal$delta
    if(length(delta) > 0){
        cat("Unit root terms:\n", "    ")
        cat(.cat_u_delta(object$internal$delta_poly), sep = "")
        cat("\n\n")
    }

    fixed <- .Sarima_fixed(object)
    est <- object$coef[!fixed]
    se <- sqrt(diag(object$var.coef))[!fixed]
    zval <- est / se
    pval <- 2 * pnorm(abs(zval), lower.tail = FALSE)
    coefs <- cbind(est, se, zval, pval)
    dimnames(coefs) <- 
        list(names(est), 
             c("Estimate", "Std. Error", "Z value", "Pr(>|z|)") )

    cat("Coefficients:\n")
    printCoefmat(coefs
                 # , digits = digits, signif.stars = signif.stars, na.print = "NA", ...
                )

    cat("\nestimated sigma^2 = ", format(object$sigma2, digits = 3), 
        ",  log-likelihood = ", format(round(object$loglik, 2)),       
        ",  aic = ", format(round(object$aic, 2L)),
        sep = "")

#browser()
    cat("\n")

    invisible(object)
}

## see also stats:::predict.Arima
predict.Sarima <- function (object, n.ahead = 1L, newxreg = NULL, se.fit = TRUE, ...){
        # myNCOL <- function(x) if (is.null(x)) 
        #     0
        # else NCOL(x)
        # rsd <- object$residuals
        # xr <- object$call$xreg
        # xreg <- if (!is.null(xr)) 
        #     eval.parent(xr)
        # else NULL
        # ncxreg <- myNCOL(xreg)
        # if (myNCOL(newxreg) != ncxreg) 
        #     stop("'xreg' and 'newxreg' have different numbers of columns")
        # class(xreg) <- NULL
        # xtsp <- tsp(rsd)
        # n <- length(rsd)
        # arma <- object$arma
        # coefs <- object$coef
        # narma <- sum(arma[1L:4L])
        # if (length(coefs) > narma) {
        #     if (names(coefs)[narma + 1L] == "intercept") {
        #         xreg <- cbind(intercept = rep(1, n), xreg)
        #         newxreg <- cbind(intercept = rep(1, n.ahead), newxreg)
        #         ncxreg <- ncxreg + 1L
        #     }
        #     xm <- if (narma == 0) 
        #         drop(as.matrix(newxreg) %*% coefs)
        #     else drop(as.matrix(newxreg) %*% coefs[-(1L:narma)])
        # }
        # else 
    ## TODO: no xreg yet
    n <- length(object$series)
    nco <- object$internal$n.coef
        # co.ind <- cumsum(c(0, nco))
                                       # 2018-02-17 repalce numeric indices in nco[] with character
    arma.ind <- seq_len(nco["arma"])
    xreg.ind <- nco["arma"] + seq_len(nco["xreg"])
    regx.ind <- nco["arma"] + nco["xreg"] + seq_len(nco["regx"])
    if(length(xreg.ind) == 0)
        xm <- 0
    else{
        trmake <- object$internal$trendMaker
        xregmat <- trmake(n + 1:n.ahead)
        xreg.coef <- object$coef[xreg.ind]
        xm <- as.vector(xregmat %*% xreg.coef)
    }
    ## TODO: no regx yet
        # if (arma[2L] > 0L) {
        #     ma <- coefs[arma[1L] + 1L:arma[2L]]
        #     if (any(Mod(polyroot(c(1, ma))) < 1)) 
        #         warning("MA part of model is not invertible")
        # }
        # if (arma[4L] > 0L) {
        #     ma <- coefs[sum(arma[1L:3L]) + 1L:arma[4L]]
        #     if (any(Mod(polyroot(c(1, ma))) < 1)) 
        #         warning("seasonal MA part of model is not invertible")
        # }
    z <- KalmanForecast(n.ahead, object$model)
        # pred <- ts(z[[1L]] + xm, start = xtsp[2L] + deltat(rsd), 
        #     frequency = xtsp[3L])
    pred <- z[[1L]] + xm
    if (se.fit) {
            # se <- ts(sqrt(z[[2L]] * object$sigma2), start = xtsp[2L] + 
            #     deltat(rsd), frequency = xtsp[3L])
        se <- sqrt(z[[2L]] * object$sigma2)
        list(pred = pred, se = se)
    }
    else pred
}

## fkf: y ~ d x 1
##      state ~ m x 1
armapqss <- function(ar, ma, sigma) {
    p <- length(ar)
    q <- length(ma)
    r <- max(p, q + 1) # fkf: m

    ear <- c(ar, numeric(max(r - p, 0)))
    ema <- c(ma, numeric(max(r - q - 1, 0)))

    Tt <- cbind(ear, rbind(diag(r - 1), 0))
    Rt <- matrix(c(1, ema), ncol = 1)

    Zt <- matrix(c(1, numeric(r - 1)), nrow = 1)

    ct <- matrix(0)                      # obs. regression
    dt <- matrix(0, nrow = r, ncol = 1)  # state regression

    GGt <- matrix(0)    # d x d

    H <- Rt * sigma
    HHt <- H %*% t(H)

    a0 <- numeric(r)
    P0 <- diag(1e6, nrow = r)
    
    list(a0 = a0, P0 = P0, ct = ct, dt = dt,
         Zt = Zt, Tt = Tt, GGt = GGt, HHt = HHt)
}

## extention of armapqss
## fkf: y ~ d x 1
##      state ~ m x 1
xarmaxss <- function(ar, ma, sigma, xreg, regx) {
    d <- 1  # dim of y, currently univariate

    p <- length(ar)
    q <- length(ma)
    r <- max(p, q + 1) # fkf: m = r

    ear <- c(ar, numeric(max(r - p, 0)))
    ema <- c(ma, numeric(max(r - q - 1, 0)))

    Tt <- cbind(ear, rbind(diag(r - 1), 0))
    Rt <- matrix(c(1, ema), ncol = 1)

    Zt <- matrix(c(1, numeric(r - 1)), nrow = d)

    ## TODO: more flexible options for ct i dt ?

    ## obs. regression
    ct <- if(missing(xreg) || length(xreg) == 0) 
              matrix(0, nrow = d)
          else
              xreg

    ## state regression
    dt <- if(missing(regx) || length(regx) == 0)
              matrix(0, nrow = r, ncol = 1)
          else  if(nrow(regx) == r)
              regx
          else # assume < r
              rbind(regx, matrix(0, nrow = r - nrow(regx), ncol = ncol(regx)))

    GGt <- matrix(0, nrow = d)    # d x d

    H <- Rt * sigma
    HHt <- H %*% t(H)

    a0 <- numeric(r)
    P0 <- diag(1e6, nrow = r)
    
    list(a0 = a0, P0 = P0, ct = ct, dt = dt,
         Zt = Zt, Tt = Tt, GGt = GGt, HHt = HHt)
}

## extention of xarmaxss
## fkf: y ~ d x 1
##      state ~ m x 1
xarimaxss <- function(ar, ma, sigma, xreg, regx, delta = numeric(0)) {
    model <- xarmaxss(ar, ma, sigma, xreg, regx)
    dd <- length(delta)
    if(dd == 0)
        return(model)
    
    model$dt <- c(model$dt, numeric(dd)) # extend dt with zeroes ## TODO: dt is a matrix!
    model$Tt <- rbind(c(delta, 1, numeric(ncol(model$Tt) - 1)),
                      dbind(diag(1, nrow = dd - 1, ncol = dd),
                            model$Tt ))
    model$Ht <- dbind(matrix(0, dd, dd), model$Ht)
    model$Zt <- c(model$Zt, numeric(dd))   # [1, 0, ...., 0] 

    model$a0 <- c(numeric(dd), model$a0)
    model$P0 <- dbind(diag(1e6, nrow = dd), model$P0)
    
        # list(a0 = a0, P0 = P0, ct = ct, dt = dt,
        #      Zt = Zt, Tt = Tt, GGt = GGt, HHt = HHt)
    model
}

sarima_KalmanLike <- function(y, mod, nit = 0L, update = FALSE)
{
        # x <- .Call(C_KalmanLike, y, mod, nit, FALSE, update)
        # z <- list(Lik = 0.5*(log(x[1L]) + x[2L]), s2 = x[1L])
        # if(update) attr(z, "mod") <- attr(x, "mod")
    x0 <- uniKalmanLikelihood0b(y, mod, nit, FALSE, update)
    x <- x0[[1]]
    x[1:2] <- x[1:2]/x[3]
    z <- list(Lik = 0.5*(log(x[1L]) + x[2L]), 
              s2 = x[1L])
    if(update) 
        attr(z, "mod") <- attr(x0, "mod")
    z
}

sarima_KalmanRun <- function(y, mod, nit = 0L, update = FALSE)
{
        # z <- .Call(C_KalmanLike, y, mod, nit, TRUE, update)
    z <- uniKalmanLikelihood0b(y, mod, nit, TRUE, update)
        # x <- z$values
    x <- z[[1]]
    x[1:2] <- x[1:2]/x[3]

        # z[[1L]] <- c(Lik = 0.5*(log(x[1L]) + x[2L]), s2 = x[1L])
        # z
    list(values = c(Lik = 0.5*(log(x[1L]) + x[2L]), s2 = x[1L]),
         resid = z[[2]],
         states = ":TODO:"
         )
}

sarima <- function(model, data = NULL, ss.method = "sarima"){
        # TODO: for now lik.method is simply "ss.method"
        #       Need to think over the user-facing arguments for methods.
    lik.method <- ss.method

    if(!inherits(model, "formula"))
        stop("unsupported class ", class(model), " of argument 'model'")

    toPolyCoef <- function(item){
        switch(item$name,
               ar  = { phi   <<- c( phi   , list(item$coef) ) },
               ma  = { theta <<- c( theta , list(item$coef) ) },
               sar = { phi   <<- c( phi   , list(item$coef) ) },
               sma = { theta <<- c( theta , list(item$coef) ) },
               i   = { delta <<- c( delta , list(item$coef) ) },
               si  = { delta <<- c( delta , list(item$coef) ) },
               s   = { delta <<- c( delta , list(item$coef) ) },
               ss  = { delta <<- c( delta , list(item$coef) ) },
                   # here item$coef is itself a list!
               su  = { delta <<- c( delta , item$coef ) },
               u   = { delta <<- c( delta , item$coef ) },
                   # unit root for estimation:
               uar = { udelta <<- c( udelta, list(item$coef) ) },
               stop("not supported yet!")
               )
    }

    Fo <- Formula(model)
    
    yname <- all.vars(formula(Fo, rhs = FALSE)) # name of the response variable
    if(length(yname) != 1)
        stop("currently there should be exactly one response variable")
    
    data.env <- environment(Fo)
    if(!is.null(data)){
        if(is.list(data)){   # list (including data.frame)
            data.env <- list2env(data, parent = data.env)
            environment(Fo) <- data.env
                            # put the response in y.
                            # TODO: I had forgotten that I do this! Is it a good idea?
            data <- model.part(Fo, data = data, lhs = 1)
            data <- as.matrix(data) # TODO: should this be as.data.frame?
        }else if(is.environment(data))
            stop("'data' from class 'environment' not supported")
        else{  # data is the time series            # TODO: consider multivariate 
            data.env <- new.env(parent = data.env)
            environment(Fo) <- data.env
            data.env[[yname]] <- data

            mf0 <- model.frame(Fo, lhs = 1, rhs = FALSE)
            data <- model.part(Fo, data = mf0, lhs = 1)
            data <- as.matrix(data) # TODO: should this be as.data.frame?
        }
    }else{
            # !!! TODO: do this for the above as well !!!
            #
            # 15/01/2018 - na.action = NULL, otherwise NA's are dropped
            # mf0 <- model.frame(Fo, lhs = 1, rhs = FALSE)
        mf0 <- model.frame(Fo, lhs = 1, rhs = FALSE, na.action = NULL)
        data <- model.part(Fo, data = mf0, lhs = 1)
        data <- as.matrix(data) # TODO: should this be as.data.frame?
    }
    stopifnot(identical(environment(Fo), data.env))



                                        # get nobs - there should be a better way, since
                                        #            calling model frame requires that the
                                        #            correct response variable is visible. I
                                        #            work only with the lhs, so the other
                                        #            variables are not needed at this stage
                                        #            (as it have to - cs, ets., are set
                                        #            using nobs further below).
    Fo.0 <- formula(Fo, lhs = 1, rhs = FALSE)

    ## 15/01/2018 - bug fix: this drops NA's!
    ##     nobs <- nrow(model.frame(Fo.0)) # TODO: model.frame() needs the environment to be set up!
                                        #       any other wy to find nobs?
                                        # DONE: Moving stuff seting the environment before this line
                                        #       but leaving this note here in case I forget.     
    nobs <- nrow(model.frame(Fo.0, na.action = NULL))
#browser()
    ## NOTE: Do not reuse Fo.0 - its environment gets out of sync with Fo.0o after the following. 
    ##      (but the data are already there, so maybe no problem.
                                        # insert an environment for the trend stuff
    data.env <- new.env(hash = FALSE, parent = environment(Fo))
    data.env$t <- seq_len(nobs)

    Fo.trend  <- formula(Fo, rhs = 1)
    Fo.trend.rhs  <- formula(Fo, lhs = FALSE, rhs = 1)

    trmake <- NULL
    if(!is.empty.model(Fo.trend)) 
        # lhs is needed if there is only intercept, otherwise nobs is unknown
            #     trmake <- trendMaker(Fo.trend.rhs, time = 1:nobs)
        trmake <- trendMaker(Fo.trend, time = 1:nobs)
    
    Fo.sarima <- formula(Fo, rhs = 2) # TODO: check for empty
    udelta <- delta <- theta <- phi <- list() # initialise variables, will be updated by toPolyCoef()
    molist <- SARIMA(Fo.sarima)
    lapply(molist, toPolyCoef)

    ## renaming Xreg to regx
    regxmake <- NULL
    if(length(Fo)[2] > 2){
        Fo.regx <- formula(Fo, rhs = 3)
	if(!is.empty.model(Fo.regx))
            regxmake <- trendMaker(Fo.regx, time = 1:nobs)
    }else{
        Fo.regx <- NULL # for clarity; currently not used         
    }

#browser()    

    res <- sarimat(data, phi, theta, delta, udelta, trmake = trmake, regxmake = regxmake,
                   lik.method = lik.method)
    res$call <- match.call() # replace the call to sarimat() with the call to sarima()
    res$formula <- model

    res$internal$Fo.xreg <- Fo.trend
    res$internal$Fo.sarima <- formula(Fo, lhs = FALSE, rhs = 2) # Fo.sarima
    res$internal$Fo.regx <- Fo.regx

#browser()

    res
}

sarimat <- function(y, phi, theta, delta, udelta, trmake = NULL, regxmake = NULL, lik.method){

    update_params <- function(par){
        ## flat_par contains the parameters as seen by optim,
        ##          except that optim only gets the nonfixed parameters 
        flat_par[nonfixed] <<- par

        ## the calculation below depend on the "real" parameters,
        ## so we tanh transform if necessary to get parcor's, then transform the parcor's
        ## to coefficients.
        
        ## this assumes that the sarima parameters are before any others
        ##    (which is the case, but this is are minder not to change it!)
        ## using integer indices rather than logical ones to avoid extending 
        ##    flags.atanh_sarima to the full length of flat_par.
        ## 
        ## TODO: In some cases this transformation may make sense for other parameters too.
        ##       But let's sort the sarima parameters first
       
        if(tanh.flag){ ## tanh() parameters to get parcor's
            wrk <- flat_par
            ## fixed parameters declared to need transform, will be transformed to and from.
            ##   TODO: fix this
            wrk[ind.atanh_sarima] <- tanh(flat_par[ind.atanh_sarima])
            par <- wrk[nonfixed]
        }
        newpars <- relist(par, par.skeleton)

        mapply(function(x, newpar){
            x$parcor[x$dyn.index] <- newpar
            x$a[-1] <- - FitAR::PacfToAR(x$parcor[-1])
        }, e_phi, newpars[["phi"]], SIMPLIFY = FALSE)
        
        mapply(function(x, newpar){
            x$parcor[x$dyn.index] <- newpar
            x$a[-1] <- FitAR::PacfToAR(x$parcor[-1])
        }, e_theta, newpars[["theta"]], SIMPLIFY = FALSE)
        

        mapply(function(x, newpar){
            x$parcor[x$dyn.index] <- newpar
            x$a[-1] <- - FitAR::PacfToAR(x$parcor[-1])
        }, e_udelta, newpars[["udelta"]], SIMPLIFY = FALSE)
        
        
        Par_treg <<- if(treg.flag) unlist(newpars[["xreg"]])
                     else numeric(0)
        
        Par_const <<- if(X.flag) unlist(newpars[["regx"]])
                      else numeric(0)
        NULL
    }
    
    makePhiTheta <- function(){
        Phi <<- - coef(sprod(phi_poly))[-1]
        if(length(Phi) != Phi_length)
            Phi <<- c(Phi, numeric(Phi_length - length(Phi)))
        
        Theta <<- coef(sprod(theta_poly))[-1]
        if(length(Theta) != Theta_length)
            Theta <<- c(Theta, numeric(Theta_length - length(Theta)))


        Phi <<- - coef(sprod(phi_poly))[-1]
        
	Delta_prod <<- delta_prod * sprod(udelta_poly)
	Delta <<- - coef(Delta_prod)[-1]    
        if(length(Delta) != Delta_length)
            Delta <<- c(Delta, numeric(Delta_length - length(Delta)))
    }
    
    makeArimaConst <- function(const, ...){
        ## see Durbin/Koopman, p. 61
        ## only const for now, since otherwise Z would be time dependent.
        mod <- makeARIMA(...)
        mod$Z <- c(1, mod$Z)
        mod$a <- c(const, mod$a)
        
	## not Matrix::bdiag() for a reason
	##  - package currently doesn't import Matrix
	##  - needs to be able to handle e.g. a 0-row matrix
        mod$P  <- rbind(c(const, numeric(ncol(mod$P))),  cbind(0, mod$P))
        mod$Pn <- rbind(c(0, numeric(ncol(mod$Pn))), cbind(0, mod$Pn))
        mod$T  <- rbind(c(1, numeric(ncol(mod$T))),  cbind(0, mod$T))
        ## V = RQR', diag_bind(0, V), i.e. non-random intercept
        mod$V <- rbind(c(0, numeric(ncol(mod$V))), 
                       cbind(0, mod$V))
        mod
    }
    
    loglik <- function(par){
        update_params(par)
        
        makePhiTheta() # expand polynomials
        if(X.flag){
            model_from_makeARIMA <<- makeArimaConst(Par_const, Phi, Theta, Delta)
        }else
            model_from_makeARIMA <<- makeARIMA(Phi, Theta, Delta)
        
        if(treg.flag)
            yc <<- y - tregmat %*%  Par_treg
#browser()        
        fromKalman <<- KalmanLike(yc, model_from_makeARIMA)
        
        fromKalman$Lik
    }
    
    loglik_sarima <- function(par){
        update_params(par)
        
        makePhiTheta() # expand polynomials
        if(X.flag){
            model_from_makeARIMA <<- makeArimaConst(Par_const, Phi, Theta, Delta)
        }else
            model_from_makeARIMA <<- makeARIMA(Phi, Theta, Delta)
        
        if(treg.flag)
            yc <<- y - tregmat %*%  Par_treg
        
                        # fromKalman <<- KalmanLike(yc, model_from_makeARIMA)
        fromKalman <<- sarima_KalmanLike(yc, model_from_makeARIMA)
        
        fromKalman$Lik
    }
    
    
    loglik_fkf <- function(par){
        npar.fkf <- length(par)
        
        update_params(par[- npar.fkf])
        
        sigma <<- exp(par[npar.fkf])
        makePhiTheta() # expand polynomials
        ## TODO: check X.flag, etc.
        ct <- t(tregmat %*%  Par_treg)
        dt <- t(regxmat %*%  Par_const)

        fkf.model <<- xarimaxss(ar = Phi, ma = Theta, sigma = sigma, 
                                xreg = ct, regx = dt, delta = Delta)
        
        
        fromKalman <<- fkf(a0 = fkf.model$a0, P0 = fkf.model$P0,
                           dt = fkf.model$dt, ct = fkf.model$ct,
                           Tt = fkf.model$Tt, Zt = fkf.model$Zt, 
                           HHt = fkf.model$HHt, GGt = fkf.model$GGt, 
                           yt = matrix(y, nrow = 1))
        - fromKalman$logLik # TODO: - $logLik, while in "base" it is $Lik !!!
    }

    loglik_kfas <- function(par){
        npar.fkf <- length(par) # last param is log(sigma2) (In FKF it is log(sigma))

        update_params(par[- npar.fkf])
            # ## TODO: correct the hessian later
            # beta <- tanh(par[- npar.fkf])
            # cat("beta = ", beta, "\n")        
	    # 
            # update_params_kfas(beta)
        ## TODO: is it better to use sigma as parameter for optim()?
        ##        (better scaling?)
        sigma2 <<- exp(par[npar.fkf]) # TODO: check - is this sigma2 or sigma squared?

        makePhiTheta() # expand polynomials
                                        # if(X.flag){
                                        #     model_from_makeARIMA <<- makeArimaConst(Par_const, Phi, Theta, Delta)
                                        # }else
                                        #     model_from_makeARIMA <<- makeARIMA(Phi, Theta, Delta)
                                        # if(treg.flag)
                                        #     yc <<- y - tregmat %*%  Par_treg
                                        # 
                                        # fromKalman <<- KalmanLike(yc, model_from_makeARIMA)
                                        # 
                                        # fromKalman$Lik
        ## TODO: integrated, trends etc,

              # ct <- t(tregmat %*%  Par_treg)
              # dt <- t(regxmat %*%  Par_const)
              # fkf.model <<- xarimaxss(ar = Phi, ma = Theta, sigma = sigma, 
              #                         xreg = ct, regx = dt, delta = Delta)

              # from makeUpdateFun_arma0() and KFAS examples
              #   TODO: only ARMA w.o. intercept for now.        
        wrk <- try(SSMarima(Phi, Theta, Q = sigma2), silent = TRUE)

        if(inherits(wrk, "try-error")){
#            cat("1e100 !!\n")
            return(1e100)
        }

        kfas_model["T", "arima"]  <<- wrk$T
        kfas_model["R", "arima"]  <<- wrk$R
        kfas_model["P1", "arima"] <<- wrk$P1
        kfas_model["Q", "arima"]  <<- wrk$Q
     
        fromKalman <<- list(logLik = logLik(kfas_model))
        - fromKalman$logLik # TODO: - $logLik, while in "base" it is $Lik !!!
    }

    
    poly_param <- function(x, fixed = attr(x, "fixed"), nseasons = attr(x, "nseasons"),
                           d = attr(x, "d", exact = TRUE),
                           atanh.tr = attr(x, "atanh.tr", exact = TRUE) ){
        coef <- if(!is.null(attr(x, "sign")) && attr(x, "sign") == "-")
                    c(1, - x)
                else 
                    c(1, x)
        
                             # polynom() drops trailing zeroes and doesn't accept NA's.
                             #   to protect against these, create a polynomial of 1's first
        res <- polynom(rep(1, length(coef)))
        
        ## TODO: krapka - replace NA's with zeroes
        if(anyNA(coef))
            coef[is.na(coef)] <- 0
        
        e <- environment(res)
        e$a <- coef
        e$fixed <- if(is.null(fixed)) 
                       c(TRUE, rep(FALSE, length(coef) - 1))
                   else
                       c(TRUE, fixed)
        
        e$dyn.index <- which(!e$fixed)

        ## 18/01/2017 - support for atanh transform
        ## TODO: maybe different defaults for AR and MA? but here it is not known if
        ##       the parameter is AR or MA.
        
        ## It is best for the default here to be FALSE since otherwise the caller
        ## will have to take care of this even for model elements for which this
        ## doesn't make sense. In any case, the default here is not that important
        ## since sarima() may set these.
        e$atanh.tr <- if(is.null(atanh.tr)) 
                       c(FALSE, rep(FALSE, length(coef) - 1))
                   else
                       c(FALSE, atanh.tr)
        ## TODO: for now there seems no need for analog of dyn.index (see above)        
        
        if(!is.null(nseasons)){
            ## TODO: check for whole number
            if(is.numeric(nseasons) && length(nseasons) == 1  && nseasons  > 0){
                e$nseasons <- nseasons
            }else
                stop("'nseasons' must be a positive integer or NULL")
        }

        if(!is.null(d)  &&  d > 1){
            e$d <- d
        }
        
        if(!is.null(dnam <- attr(x, "dispname")))
            e$dispname <- dnam
        
        res
    }
    
    sprod <- function(pp){ # pp is short for parameter polynomial
        f <- function(poly){
            s <- environment(poly)$nseasons
            if(is.null(s)) 
                poly
            else
                poly(poly_x^s)
        }
        prod(as.polylist(lapply(pp, f)))
    }
    
    u_sprod <- function(pp){ # pp is short for parameter polynomial
        f <- function(poly){
            s <- environment(poly)$nseasons
            if(!is.null(s)) 
                poly <- poly(poly_x^s)
            d <- environment(poly)$d
            if(is.null(d)) poly  else poly^d
        }
        prod(as.polylist(lapply(pp, f)))
    }
    
    
    sdegree <- function(pp){
        e <- environment(pp)
        s <- e$nseasons
        degree <- length(e$a) - 1
        if(!is.null(s)) 
             degree <- degree * s
        if(!is.null(e$d))
             degree <- degree * e$d
        degree
    }

    ## TODO: this is krapka for naming multple ar() terms, etc.
    poly_param_plus <- function(parlist){
        no <- 0
        sno <- 0
        res <- vector(length(parlist), mode = "list")
        for(i in seq_along(parlist)){
            wrk <- poly_param(parlist[[i]])
            e <- environment(wrk)
            if(is.null(e$nseasons)){
                e$name.counter <- no
                no <- no + 1
            }else{
                e$name.counter <- sno
                sno <- sno + 1
            }
            res[[i]] <- wrk
        }
        as.polylist(res)
    }
                             # phi, theta and delta are used only here. 
                             # TODO: maybe the they can come as polynomials to sarimat() ?
    phi_poly   <- poly_param_plus(phi)
    theta_poly <- poly_param_plus(theta)
    delta_poly <- poly_param_plus(delta)
    udelta_poly <- poly_param_plus(udelta)
                                          # Delta is fixed, so needs to be computed only once
    ## TODO: (1-x)^d is kept as 1-x and a 'd' is a sepaarate varible. 
    ##       the element of delta_poly corresponding to this will print as 1 - x.
    ##       u_sprod(), print.Sarima(), summary.Sarima() know this but ing eneral this is very fragile. 
    delta_prod <- u_sprod(delta_poly) 
    udelta_prod <- sprod(udelta_poly) # NOTE: this is not  u_sprod(udelta_poly)
    
    Par_const <- Par_treg <- Phi <- Theta <- numeric(0)
    yc <- y
    
    sigma <- sd(y)   # for fkf
    sigma2 <- var(y) # for kfas
    
    kfas_model <- fkf.model <- fromKalman <- model_from_makeARIMA <- NULL
    
    Delta_prod <- delta_prod * udelta_prod
    Delta <- - coef(Delta_prod)[-1]    

    e_phi   <- lapply(phi_poly, environment)
    e_theta <- lapply(theta_poly, environment)
    e_delta <- lapply(delta_poly, environment)
    e_udelta <- lapply(udelta_poly, environment)
    
    e_phi_theta <- c(e_phi, e_theta)
    e_phi_theta_delta <- c(e_phi_theta, e_delta)

    e_phi_theta_udelta <- c(e_phi_theta, e_udelta)


    Phi_length <- if(length(phi_poly) > 0) sum(sapply(phi_poly, sdegree)) else 0
    Theta_length <- if(length(theta_poly) > 0) sum(sapply(theta_poly, sdegree))  else 0

    Udelta_length <- if(length(udelta_poly) > 0) sum(sapply(udelta_poly, sdegree)) else 0
    delta_length <- if(length(delta_poly) > 0) sum(sapply(delta_poly, sdegree)) else 0
    Delta_length <- delta_length + Udelta_length 

    prepare_parcor <- function(envir){
        if(is.null(envir$parcor)){
            envir$parcor <- c(1, ar2Pacf(- envir$a[-1]))
        }else if(length(envir$parcor) != length(envir$a))
            stop("lengths of coef and parcor are not equal")

        if(anyNA(envir$parcor)) # todo: give a warning in this case?
            envir$parcor[is.na(envir$parcor)] <- 0
        NULL
    }
                                   # set initial values for parcor's (transformed params)
                                   # also: "parcor's don't make sense for delta!
    lapply(e_phi_theta, prepare_parcor)
    lapply(e_udelta, function(e) e$parcor <- e$a)  # TODO: $parcor should be set outright, this is a hack
                                   # TODO: this is just wrong, but not used:
    lapply(e_delta, function(e) e$parcor <- e$a)  # TODO:delta  !!!!!

    flags.atanh_sarima <- unlist(lapply(e_phi_theta_udelta,
                              function(x)
                                  if(isTRUE(x$operator)) logical(0) else x$atanh.tr
                              ))
    if(length(flags.atanh_sarima) == 0) ## in case it is list()
        flags.atanh_sarima <- logical(0) 

    ind.atanh_sarima <- which(flags.atanh_sarima)
    tanh.flag <- any(flags.atanh_sarima)

    Par_sarima <- unlist(lapply(e_phi_theta_udelta,
                              function(x)
                                  if(isTRUE(x$operator)) numeric(0) else x$parcor
                              ))

    stopifnot(length(Par_sarima) == length(flags.atanh_sarima))

    if(tanh.flag)
        Par_sarima[flags.atanh_sarima] <- atanh(Par_sarima[flags.atanh_sarima])


    X.flag <- !is.null(regxmake)
    treg.flag <- !is.null(trmake)
    ## now prepare the treg parameters
    ## time regression
   
    ## set up xreg
    if(treg.flag){
        tregmat <- trmake()

        if(length(Delta) > 0){
            treg.temp <- trmake((1 - length(Delta)) : nrow(tregmat))
            treg.temp <- cbind(c(rep(NA_real_, length(Delta)), y), 
                               treg.temp)

                     # TODO: use filter()
            ## start from the last row to do it in-place
            for(i in nrow(treg.temp):(length(Delta) + 1)){
                for(j in 1:length(Delta)){
                    treg.temp[i, ] <- treg.temp[i, ] - Delta[j] * treg.temp[i - j, ]
                }
            }
            ## drop the added rows
            treg.temp <- treg.temp[-(1:length(Delta)), ] 
            ydiff <- treg.temp[-(1:length(Delta)), 1]
            tregdiff <- treg.temp[-(1:length(Delta)), -1]
            fitinit <- lm(ydiff ~ tregdiff - 1, na.action = na.omit)
            Par_treg <- coef(fitinit)
        }else{
               # Tova nyama da e vyarno ako ima regx:
               #     if(ncol(tregmat) == 1  &&  all(tregmat == 1)){
               #         colnames(tregmat) <- "mean"
               #     }
            fitinit <- lm(y ~ tregmat - 1, na.action = na.omit)
            Par_treg <- coef(fitinit)
        }

    }else{#treg.flag = FALSE
        tregmat <- matrix(0, nrow = length(y), ncol = 0)
        Par_treg <- numeric(0)
    }

    ## set up regx
    if(X.flag){
        regxmat <- regxmake()

        fitinit <- lm(y ~ regxmat - 1, na.action = na.omit)
        Par_const <- coef(fitinit)
    }else{
        regxmat <- matrix(0, nrow = length(y), ncol = 0)
        Par_const <- numeric(0)
    }

                  # note: flat_par includes the coeffcients of zero power of the polynomials
    flat_par <- c(Par_sarima, Par_treg, Par_const)

    fixed <- unlist(lapply(e_phi_theta_udelta, 
                           function(x)
                               if(isTRUE(x$operator)) logical(0) else x$fixed
                           ))

                                            # TODO: for now no fixed treg parameters
                                            #       use 'offset' if possible?
    Par_treg_fixed  <- rep(FALSE, length(Par_treg)) 
    Par_const_fixed <- rep(FALSE, length(Par_const))

    fixed <- c(fixed, Par_treg_fixed, Par_const_fixed)

    ## note: flat_par includes the coeffcients of zero power of the polynomials;
    ##       so, flat_par[nonfixed] includes them, too! 
    nonfixed <- !fixed

    par.skeleton <- list(phi = lapply(e_phi, function(e) e$dyn.index),
                         theta = lapply(e_theta, function(e) e$dyn.index),
                         udelta = lapply(e_udelta, function(e) e$dyn.index),
                         # delta = lapply(e_delta, function(e) e$dyn.index),
                         xreg = list(seq_along(Par_treg)),
                         regx = list(seq_along(Par_const))
                         )
    ## optimise
    switch(lik.method, 
           base = {
               loglik(flat_par[nonfixed])
               res_opt <- optim(flat_par[nonfixed], loglik, method = "BFGS", hessian = TRUE)
                        # update the quantities with the result from the optim:
                        # (the last call of loglik() by optim() may not be the final result)
               loglik(res_opt$par) # identical(res_opt$value, fromKalman$Lik) should be TRUE
           },
           sarima = {
               loglik_sarima(flat_par[nonfixed])
               res_opt <- optim(flat_par[nonfixed], loglik_sarima, method = "BFGS", hessian = TRUE)
               if(tanh.flag){
                   ## lazy: call optim with the untransformed parameters with zero maxit,
                   ##       simply to get the hessian for the untransformed parameters.
                   ## todo: however the current setup makes this difficult

                   ## save some vars
                   tanh.flag <- FALSE
                   sav_flat_par <- flat_par

                   ## tanh() to get parcor's
                   flat_par[ind.atanh_sarima] <- tanh(flat_par[ind.atanh_sarima])

                   ## this is only needed for the hessian
                   res_opt_alt <- optim(flat_par[nonfixed], loglik_sarima, method = "BFGS", hessian = TRUE,
                                       control = list(maxit = 0L))
                   flat_par <- sav_flat_par  # restore saved vars
                   tanh.flag <- TRUE
               }


                        # update the quantities with the result from the optim:
                        # (the last call of loglik() by optim() may not be the final result)
               loglik_sarima(res_opt$par) # identical(res_opt$value, fromKalman$Lik) should be TRUE


           },
           fkf = {
               loglik_fkf(c(flat_par[nonfixed], log(sigma)))
               res_opt <- optim(c(flat_par[nonfixed], log(sigma)),
                                loglik_fkf, method = "BFGS", hessian = TRUE)
               loglik_fkf(res_opt$par)
           },
           kfas = {
                 # SSMarima() returns a list
                 # kfas_model <- try(SSMarima(Phi, Theta, Q = sigma2), silent = TRUE)
               ## loglik_kfas() doesn't recreate the full model,
               ## so create it in advance (could add if(is.null(kfas_model)) ... to loglik_kfas)
               update_params(flat_par[nonfixed])
               makePhiTheta() # expand polynomials
               
               kfas_model <- SSModel(y ~ -1 + SSMarima(Phi, Theta, Q = sigma2), H = 0)
                    # kfas_init <- c(atanh(flat_par[nonfixed]), log(sigma2))
               kfas_init <- c(flat_par[nonfixed], log(sigma2))
               loglik_kfas(kfas_init)
               res_opt <- optim(kfas_init, loglik_kfas, method = "BFGS", hessian = TRUE)
               loglik_kfas(res_opt$par)
           },
           arima = {
               ## this methods calls arima()
               if(length(Par_const) > 0)
                   stop("method 'arima' can handle 'xreg', but not 'regx'")
                   
               ## TODO: finish this
               stop("method arima is unfinished")
           }, 
           stop("invalid 'lik.method'")
           )

    fcoef <- function(x, minus = FALSE){ 
        res <- x$a[-1]
        if(minus)
            res <- - res
        if(!is.null(nam <- x$dispname)){
            suffix <- letters[x$name.counter] # should be ok for NULL and 0 
            names(res) <- paste0(nam, seq_along(res), suffix)
        }
        res
    }
    
    coef_phi   <- lapply(e_phi, function(x) fcoef(x, TRUE))
    fixed_phi  <- lapply(e_phi, function(x)   x$fixed[-1])
    
    coef_theta  <- lapply(e_theta, fcoef)
    fixed_theta <- lapply(e_theta, function(x)   x$fixed[-1])

    coef_delta  <- lapply(e_delta, function(x) fcoef(x, TRUE))
    fixed_delta <- lapply(e_delta, function(x)   x$fixed[-1])

    coef_udelta  <- lapply(e_udelta, function(x) fcoef(x, TRUE))
    fixed_udelta <- lapply(e_udelta, function(x)   x$fixed[-1])

    all.coef <- unlist(c(coef_phi, coef_theta, coef_udelta, coef_delta, Par_treg, Par_const))
    all.fixed <- unlist(c(fixed_phi, fixed_theta, fixed_udelta, fixed_delta, Par_treg_fixed, Par_const_fixed))

    coef.nonfixed <- unlist(all.coef)[!all.fixed]

                                        # TODO: think about better names, can clean them up here
    if(length(Par_treg) > 0)
        names(Par_treg) <- colnames(tregmat)
    if(length(Par_const) > 0)
        names(Par_const) <- colnames(regxmat)
                                   # no delta here, but all this needs further thought
                                   # TODO: need to add numbers to c("ar", "ar"), etc
    coef       <- unlist(c(coef_phi, coef_theta, coef_udelta, Par_treg, Par_const))
    fixed_coef <- unlist(c(fixed_phi, fixed_theta, fixed_udelta, Par_treg_fixed, Par_const_fixed))

    ## TODO: Tova e krapka, ako e list() ili NULL , !fixed_coef po-dolu dava greshka.
    if(length(fixed_coef) == 0)
        fixed_coef <- logical(0)     

    n.coef <- c(arma = length(unlist(c(coef_phi, coef_theta))), 
          # TODO: reinstate but change predict.Sarima to use indexing with names
                uar  = length(unlist(coef_udelta)),
                xreg = length(Par_treg), 
                regx = length(Par_const))

   mask <- !fixed_coef
               # n.cond in arima is only for method CSS, maybe should drop it here.
    ncond <- 0 # max(length(Phi), length(Theta) + 1) # TODO: Fix this!

                                       # in arima() n.used is:
                                       #     n.used <- sum(!is.na(x)) - length(Delta)
                                       # (with additional correction for missing values in xreg).
                                       # TODO: do the correction for xreg.
    notna <- !is.na(y)
    n.used <- if(length(Delta) == 0)
                  sum(notna)
              else if(all(!is.na(y[1:length(Delta)])))
                  sum(notna) - length(Delta)
              else{ # NA's among the first length(Delta) values - additional loss
                    # if there is a stretch of length(Delta) non-NA's all subsequent obs. are ok
                    # but the exact number of non-ok depends also on zero coefficients in Delta
                    # (e.g. for 1 - B^12)
## TODO: remove this or further modify at least for ss.method = "sarima"
                  available <- !is.na(y)
                  statable <- rep(FALSE, length(y))
                  
                  ddind <- which(Delta != 0)

                  okseq <- 0
                  for(t in (length(Delta) + 1):length(y)){
                      statable[t] <- all(statable[t - ddind] | available[t - ddind])
                      if(statable[t])
                          okseq <- okseq + 1
                      else
                          okseq <- 0
                      if(okseq >= length(Delta)){
                          if(t < length(y))
                              statable[(t + 1):length(y)] <- TRUE
                          break
                      }
                  }
                  ## !!! TODO: statable may be useful to choose which residuals to use etc.
                  sum(statable)
              }
    
    switch(lik.method,
           base = { 
            # arima(): value <- 2 * n.used * res$value + n.used + n.used * log(2 * pi)
            #          aic <- if(method != "CSS") value + 2*sum(mask) + 2 else NA
            
            # KalmanLike() returns minus log-likelihood, upto a scaling and addition of constants
            # (not fully documented, the following is a guess from trial and error and regression)
           
                                # equivalently, can replace  fromKalman$Lik  with  res_opt$value
               value_loglik <- - n.used * fromKalman$Lik - 0.5 * n.used * log(2 * pi) - 0.5 * n.used
            # I don't fully understand argument 'nit', but setting it to zero seems
            # to be right for prediction (setting it to -1 gives different results), compare:
            #     fromKalmanRun <- KalmanRun(y, model_from_makeARIMA, -1, update = TRUE)
            #     fromKalmanRun <- KalmanRun(y, model_from_makeARIMA,  0, update = TRUE)
               fromKalmanRun <- KalmanRun(yc, model_from_makeARIMA, 0, update = TRUE)
               resid <- fromKalmanRun$resid
    
            # TODO: sigma2 needs more care.
            #        This reproduces (it seems) arima()'s sigma2 in the absence of NA's
               ndrop_sigma2 <- length(Delta)
               sigma2 <- if(ndrop_sigma2 == 0)
                             mean(resid^2, na.rm = TRUE)
                         else
                             mean(resid[-seq_len(ndrop_sigma2)]^2, na.rm = TRUE)
                             sigma <- sqrt(sigma2)
                             ## should be ready for prediction (minus exogeneous vars)
                             ss.model <- attr(fromKalmanRun, "mod") # model_from_makeARIMA
                             coef_hessian <- res_opt$hessian
#browser()
           },
           sarima = {
               ## for now same as "base" but calling my likelihood code
 
               value_loglik <- - n.used * fromKalman$Lik - 0.5 * n.used * log(2 * pi) - 0.5 * n.used
            # I don't fully understand argument 'nit', but setting it to zero seems
            # to be right for prediction (setting it to -1 gives different results), compare:
            #     fromKalmanRun <- KalmanRun(y, model_from_makeARIMA, -1, update = TRUE)
            #     fromKalmanRun <- KalmanRun(y, model_from_makeARIMA,  0, update = TRUE)
 
        ## TODO: this needs changing, but lets first sort out the estimation
        ##        The C++ function  uniKalmanLikelihood0b needs amending to return states and
        ##        the updated model
        ##    fromKalmanRun <- sarima_KalmanRun(yc, model_from_makeARIMA, 0, update = TRUE)
               fromKalmanRun <- KalmanRun(yc, model_from_makeARIMA, 0, update = TRUE)
               
               resid <- fromKalmanRun$resid
    
            # TODO: sigma2 needs more care.
            #        This reproduces (it seems) arima()'s sigma2 in the absence of NA's
               ndrop_sigma2 <- length(Delta)
               sigma2 <- if(ndrop_sigma2 == 0)
                             mean(resid^2, na.rm = TRUE)
                         else
                             mean(resid[-seq_len(ndrop_sigma2)]^2, na.rm = TRUE)
                             sigma <- sqrt(sigma2)
                             ## should be ready for prediction (minus exogeneous vars)
                             ss.model <- attr(fromKalmanRun, "mod") # model_from_makeARIMA
                             ## TODO: it may be better not to call again optim 
                             ##       but to transform the hessian as in fitArma0Model()
                             coef_hessian <- if(tanh.flag)
                                                 res_opt_alt$hessian
                                             else
                                                 res_opt$hessian
           },
           fkf = {
               value_loglik <- fromKalman$logLik
               ## fkf puts other useful stuff in the answers
               resid <- as.vector(fromKalman$vt)
               sigma2 <- sigma^2
               ss.model <- fkf.model
               nrhess <- dim(res_opt$hessian)[1] # hess is square matrix
               coef_hessian <- res_opt$hessian[- nrhess, - nrhess] # drop logsigma
           },
           kfas = {
               value_loglik <- fromKalman$logLik
               ## fkf puts other useful stuff in the answers
               resid <- as.vector(fromKalman$vt) # TODO: this is incorrect!
               ss.model <- kfas_model
               nrhess <- dim(res_opt$hessian)[1] # hess is square matrix
               coef_hessian <- res_opt$hessian[- nrhess, - nrhess] # drop logsigma
           },
           arima = {
               stop("Should not get this far, 'arima' method not supported yet.")
           },
           
           stop("'lik.method' not found.")
           )

    aic <- - 2 * value_loglik + 2 * sum(nonfixed) + 2
    
    transformed_par <- list(lapply(e_phi, function(x) x$parcor),
                            lapply(e_theta, function(x) x$parcor),
                            lapply(e_udelta, function(x) x$parcor), 
                            lapply(e_delta, function(x) x$parcor)   )

    phipar_only  <- unlist(lapply(e_phi, function(x) x$a[-1]))
    phipar_fixed <- unlist(lapply(e_phi, function(x) x$fixed[-1]))

    thetapar_only  <- unlist(lapply(e_theta, function(x) x$a[-1]))
    thetapar_fixed <- unlist(lapply(e_theta, function(x) x$fixed[-1]))

                                                         # Jphi, Jtheta are lists of matrices 
          # transformed par are the parcor's
    Jphi <- lapply(transformed_par[[1]], function(x) pacf2ArWithJacobian(x[-1])$J )
        # Jtheta <- lapply(transformed_par[[2]], function(x) pacf2ArWithJacobian(x[-1], TRUE)$J)
    Jtheta <- lapply(transformed_par[[2]], function(x) pacf2ArWithJacobian(x[-1], TRUE)$J)

    Judelta <- lapply(transformed_par[[3]], function(x) pacf2ArWithJacobian(x[-1])$J )

    JphiJtheta <- dbind(Jphi, Jtheta)
    JphiJthetaJudelta <- dbind(Jphi, Jtheta, Judelta)


        # TODO: for ss.method = "sarima" this is done by calling again optim().
        #       see the comments there.
        # if(tanh.flag){
        #     ## tanh applied before sending  params to optim() 
        #     ##      note that some methods process this internally, e.g. "base";
        #     ##      the correction here is needed only for methods who explicitly request it.
        #     ## see also fitArma0Model()
        # 	                     # Jtanh <- diag(1/cosh(arma0_fit$par[seq_len(p+q)])^2)
        #                          # J <- JphiJtheta %*% Jtanh             
        #     phithetapar_only <- c(phipar_only, thetapar_only)
        #     JphiJtheta <- JphiJtheta / rep(cosh(phithetapar_only)^2, each = length(phithetapar_only))
        #     stop("unfinished feature")
        # }

            # J <- dbind(Jphi, Jtheta, diag(length(Par_treg)), diag(length(Par_const)))
        # J <- dbind(JphiJtheta, diag(length(Par_treg)), diag(length(Par_const)))
    J <- dbind(JphiJthetaJudelta, diag(length(Par_treg)), diag(length(Par_const)))

    if(any(fixed_coef))
        J <- J[!fixed_coef, !fixed_coef]
    
    var_coef <- if(length(coef_hessian) == 0)
                    matrix(0, 0, 0)
                else if(lik.method %in% c("fkf", "kfas"))
                          # fkf returns the hessian scaled, J H^(-1) J'
                          #  (no, it is from optim! Is the likelihood scaled differently?)
                          #  see the examples in FKF
                    hessian2vcov(coef_hessian, 1, J)
                else
                    hessian2vcov(coef_hessian, n.used, J)
            # This code adds rows and columns (of zeroes) for the fixed params.
            #    Removing since this is only trouble (and e.g. arima() doesn't do that).
            # if(any(fixed_coef)){
            #     vcov <- matrix(0, length(coef), length(coef))
            #     vcov[!fixed_coef, !fixed_coef] <- var_coef
            # }else
            #     vcov <- var_coef
    vcov <- var_coef
    if(is.null(colnames(vcov))){
        rownames(vcov) <- colnames(vcov) <- names(coef)[!fixed_coef]
    }


    ## TODO: complete
    compact_arima <- as.integer(c(p = length(Phi), q = length(Theta),
                                  s = 1, P = 0, Q = 0))
    
#browser()

    res <- structure(list(
        ## fields for class Arima (e.g. of the results of arima())
        coef      = coef, 
        sigma2    = sigma2,
        var.coef  = vcov, # var, 
        mask      = mask,
        loglik    = value_loglik,
        aic       = aic,
        arma      = compact_arima, # arma, 
        residuals = resid,
        call      = match.call(),
        series    = y, 
        code      = res_opt$convergence,
        n.cond    = ncond,
        nobs      = n.used, 
        model     = ss.model,
        ## additional fields from me
        res_opt <- res_opt,
        internal = list(
                        phi = phi,
                        theta = theta,
                        delta = delta,

                        phi_poly   = phi_poly,
                        theta_poly = theta_poly,
                        delta_poly = delta_poly,

                        Phi = Phi,
                        Theta = Theta,
                        Delta = Delta,

                        fixed = all.fixed,
                        nonfixed = coef.nonfixed,
                        flat_par = flat_par,
                        fromKalman = fromKalman,
                        transformed_par = transformed_par,

                        n.coef = n.coef,
                        trendMaker = trmake,
                        regxMaker = regxmake
        )
        ## for now inherit from class Arima (the class from arima()),
        ## eventually do not do this
    ), class = c("Sarima", "Arima")) 

#browser()
    res
    }

sarimaReport <- function(o1, o2, ...){

    list(
        all.equal(coef(o1), coef(o2))
        )


}

factorizeMA <- function(x, theta = NULL, tol = 1e-12, maxiter = 1000){
    q <- length(x) - 1
    if(is.null(theta))
        theta <- c(sqrt(x[1] + 2 * sum(x[-1])), rep(0, q))

    storage.mode(theta) <- "double"

        # r <- ltsa::tacvfARMA(theta = -theta[-1]/theta[1], maxLag = q, sigma2 = theta[1]^2)
    r <- .Call("_sarima_MAacvf0", theta)
#cat( "theta = ", theta, ",\t r = ", r, "\n")

    crit <- 1e100
    iter <- 0
    while(crit > tol  &&  iter <= maxiter){
        iter <- iter + 1
        T <- .Call("_sarima_DAcvfWrtMA", theta)

        theta <- solve(T, r + x)

        r <- ltsa::tacvfARMA(theta = -theta[-1]/theta[1], maxLag = q, sigma2 = theta[1]^2)

        rnew <- .Call("_sarima_MAacvf0", as.double(theta)) # MAacvf0(theta)

#cat( "theta = ", theta, ",\t r = ", r, "\n")
#browser()
        crit <- sum((x - r)^2)
    }

    ## output as SQUAREM::fpiter(), maybe should use it anyway.
    list(par = theta, value.objfn = crit, fpevals = iter, 
        objfevals = iter, convergence = if(iter > maxiter) 1 else 0)

}

##  arimaSS <- function(y, mod)
##     {
##         ## next call changes mod components a, P, Pn so beware!
##         .Call(stats:::C_ARIMA_Like, y, mod, 0L, TRUE)
##     }
