% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colour.R
\name{get_colour_set}
\alias{get_colour_set}
\title{Provide A Colour Set for A Number of Requested Colours}
\usage{
get_colour_set(
  x,
  common_data_type = "factor",
  colour_palette_nominal = NULL,
  colour_palette_ordinal = NULL,
  colour_na = NULL,
  colour_2nd_binary_cat = NULL,
  ordinal = FALSE,
  categories_treated_as_na = NULL,
  call = rlang::caller_env()
)
}
\arguments{
\item{x}{Vector for which colours will be found.}

\item{common_data_type}{\emph{factor or ordered data type}

\verb{scalar<character>} // \emph{default:} \code{factor} (\code{optional})

Currently only supports factor and ordered.}

\item{colour_palette_nominal, colour_palette_ordinal}{\emph{User specified colour set}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

User-supplied default palette, excluding \code{colour_na}.}

\item{colour_na}{\emph{Colour for NA category}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Colour as a single string for NA values.}

\item{colour_2nd_binary_cat}{\emph{Colour for second binary category}

\verb{scalar<character>} // \emph{default:} \code{"#ffffff"} (\code{optional})

Colour for second category in binary variables. Often useful to hide this.}

\item{ordinal}{\verb{scalar<logical>} // \emph{default:} \code{FALSE} (\code{optional})

Is palette ordinal?}

\item{categories_treated_as_na}{\emph{NA categories}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

Categories that should be treated as NA.}

\item{call}{\emph{Internal call}

\verb{obj:<call>} // \emph{Default:} \code{rlang::caller_env()} (\code{optional})

Both the absolute and relative folderpaths are required, as strings.}
}
\value{
A colour set as character vector, where \code{NA} has the \code{colour_na}, and the rest are taken from colour_palette_nominal if available.
}
\description{
Possibly using colour_palette_nominal if available. If not sufficient, uses a set
palette from RColorBrewer.
}
\examples{
get_colour_set(x=1:4)
}
