% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplifyGtypes.R
\name{simplifyGtypes}
\alias{simplifyGtypes}
\title{Simplify detailed grain types to parent classes}
\usage{
simplifyGtypes(gtypes, supported_gtypes = grainDict$gtype)
}
\arguments{
\item{gtypes}{an array of character grain types following IACS standards}

\item{supported_gtypes}{an array of supported grain types that will determine the simplification}
}
\value{
the modified input array
}
\description{
The IACS records grain types in major and minor classes, e.g. precipitation particles PP can be subclassified into
stellar dendrites PPsd. Some of these subclasses are not supported in this R package and so this function simplifies
the unsupported gran type subclasses into their supported main classes. If a given grain type cannot be simplified,
a NA value is returned for it.
}
\examples{
## create an array of gtypes
gtypes <- c('FCxr', 'RGxf', 'PPsd', 'PP', 'IFrc', "KKfx")

## sinplify gtypes to supported_gtypes:
simplifyGtypes(gtypes)

}
\author{
fherla
}
