#' A sar_habitat dataset describing snails on islands in the Aegean Sea, Greece
#'
#' A sample dataset in the correct sar_habitat format: contains the areas of a
#' number of islands in the Skyros Archipelago (km2), the number of habitats,
#' and the number of land snail species recorded on each island.
#'
#' @usage data(habitat)
#' @format A data frame with 3 columns and 12 rows. Each row contains the area
#'   of an island (1st column), and the number of habitats (2nd column) and
#'   species on that island (3rd column).
#' @source Triantis, K. A., Mylonas, M., Weiser, M. D., Lika, K., &
#'   Vardinoyannis, K. (2005). Species richness, environmental heterogeneity and
#'   area: a case study based on land snails in Skyros archipelago (Aegean Sea,
#'   Greece). Journal of Biogeography, 32, 1727-1735.
#' @examples
#' data(habitat)
"habitat"
