% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sasfunclust_functions.R
\name{sasfclust_cv}
\alias{sasfclust_cv}
\title{Cross-validation for sasfclust}
\usage{
sasfclust_cv(
  X = NULL,
  timeindex = NULL,
  curve = NULL,
  grid = NULL,
  q = 30,
  lambda_l_seq = 10^seq(-1, 2),
  lambda_s_seq = 10^seq(-5, -3),
  G_seq = 2,
  tol = 10^-7,
  maxit = 50,
  par_LQA = list(eps_diff = 1e-06, MAX_iter_LQA = 200, eps_LQA = 1e-05),
  plot = FALSE,
  trace = FALSE,
  init = "kmeans",
  varcon = "diagonal",
  lambda_s_ini = NULL,
  K_fold = 5,
  X_test = NULL,
  grid_test = NULL,
  m1 = 1,
  m2 = 0,
  m3 = 1,
  ncores = 1
)
}
\arguments{
\item{X}{For functional data observed over a regular grid: a matrix of where  the rows must correspond to argument values and columns to replications.
For functional data observed over an irregular grid:  a vector of length \eqn{\sum_{i=1}^{N}n_i}, with \eqn{N}  the number of curves,
where the entries from  \eqn{\sum_{i=1}^{k-1}(n_i+1)} to \eqn{\sum_{i=1}^{k}n_i} are elements representing the observations for curve \eqn{k}.}

\item{timeindex}{A vector of length \eqn{\sum_{i=1}^{N}n_i}. The entries from  \eqn{\sum_{i=1}^{k-1}(n_i+1)} to \eqn{\sum_{i=1}^{k}n_i} provide the locations on \code{grid} of curve  \eqn{k}.
So for example, if the \eqn{k}th curve is observed at time points \eqn{t_l,t_m} of the \code{grid} then the the entries from  \eqn{\sum_{i=1}^{k-1}(n_i+1)} to \eqn{\sum_{i=1}^{k}n_i} would be \eqn{l,m}, being \eqn{n_k=2}.
If X is a matrix, timeindex is ignored.}

\item{curve}{A vector of length \eqn{\sum_{i=1}^{N}n_i}. The entries from  \eqn{\sum_{i=1}^{k-1}(n_i+1)} to \eqn{\sum_{i=1}^{k}n_i} are equal to  \eqn{k}.
If X is a matrix, curve is ignored.}

\item{grid}{The vector of time points where the curves are sampled.
For Functional data observed over an irregular grid, \code{timeindex} and \code{grid} provide the time points for each curve.}

\item{q}{The dimension of the set of B-spline functions.}

\item{lambda_l_seq}{Sequence of tuning parameter of the functional adaptive pairwise fusion penalty (FAPFP).}

\item{lambda_s_seq}{Sequence of tuning parameter of the smoothness penalty.}

\item{G_seq}{Sequence of number of clusters.}

\item{tol}{The tolerance for the stopping condition of the expectation conditional maximization (ECM) algorithms.
The algorithm stops when the log-likelihood difference between two consecutive iterations is less or equal than \code{tol}.}

\item{maxit}{The maximum number of iterations allowed in the ECM algorithm.}

\item{par_LQA}{A list of parameters for the local quadratic approximation (LQA) in the ECM algorithm.
\code{eps_diff} is the lower bound for the coefficient mean differences, values below \code{eps_diff} are set to zero.
\code{MAX_iter_LQA} is the maximum number of iterations allowed in the LQA.
\code{eps_LQA} is the tolerance for the stopping condition of LQA.}

\item{plot}{If TRUE, the estimated cluster means are plotted at each iteration of the ECM algorithm. Default is FALSE.}

\item{trace}{If TRUE, information are shown at each iteration of the ECM algorithm. Default is FALSE.}

\item{init}{It is the way to initialize the ECM algorithm. There are three ways of initialization: "kmeans", "model-based", and "hierarchical", that
provide initialization through the k-means algorithm,  model-based clustering based on parameterized finite Gaussian mixture model, and  hierarchical clustering, respectively.
Default is "kmeans".}

\item{varcon}{A vector of character strings indicating the type of coefficient covariance matrix. Three values are allowed: "full", "diagonal", and "equal".
"full" means unrestricted cluster coefficient covariance matrices allowed to be different among clusters.
"diagonal" means diagonal cluster coefficient covariance matrices that are equal among clusters.
"equal" means diagonal cluster coefficient covariance matrices, with equal diagonal entries, that are equal among clusters.
Default is "diagonal".}

\item{lambda_s_ini}{The tuning parameter used to obtain the functional data through smoothing B-splines before applying the initialization algorithm.
If NULL a Generalized cross validation procedure is used as described in Ramsay (2005). Default is NULL.}

\item{K_fold}{Number of folds. Default is 5.}

\item{X_test}{Only for functional data observed over a regular grid, a matrix  where  the rows must correspond to argument values and columns to replications of the test set. Default in NULL.}

\item{grid_test}{The vector of time points where the test set curves are sampled. Default is NULL.}

\item{m1}{The m-standard deviation rule parameter to choose \code{G} for each \code{lambda_s} and \code{lambda_l}.}

\item{m2}{The m-standard deviation rule parameter to choose \code{lambda_s} fixed \code{G} for each \code{lambda_l}.}

\item{m3}{The m-standard deviation rule parameter to choose \code{lambda_l} fixed \code{G} and \code{lambda_s}.}

\item{ncores}{If \code{ncores}>1, then parallel computing is used, with \code{ncores} cores. Default is 1.}
}
\value{
A list containing the following arguments:

\code{G_opt}: The optimal  number of clusters.

\code{lambda_l_opt}: The optimal tuning parameter of the FAPFP.

\code{lambda_s_opt}: The optimal tuning parameter of the smoothness penalty.

\code{comb_list}: The combinations of \code{G},\code{lambda_s} and \code{lambda_l} explored.

\code{CV}: The cross-validation values obtained for each combination of \code{G},\code{lambda_s} and \code{lambda_l}.

\code{CV_sd}: The standard deviations of the cross-validation values.

\code{zeros}: Fraction of domain over which the estimated cluster means are fused.

\code{ms}: The m-standard deviation rule parameters.

\code{class}: A label for the output type.
}
\description{
K-fold cross-validation procedure to choose the number of clusters and the tuning parameters for the sparse and smooth functional clustering (SaS-Funclust) method (Centofanti et al., 2021).
}
\examples{
\donttest{
library(sasfunclust)
train<-simulate_data("Scenario I",n_i=20,var_e = 1,var_b = 0.5^2)
lambda_s_seq=10^seq(-4,-3)
lambda_l_seq=10^seq(-1,0)
G_seq=2
mod_cv<-sasfclust_cv(X=train$X,grid=train$grid,G_seq=G_seq,
lambda_l_seq = lambda_l_seq,lambda_s_seq =lambda_s_seq,maxit = 20,K_fold = 2,q=10)
plot(mod_cv)
}
}
\references{
Centofanti, F., Lepore, A., & Palumbo, B. (2021).
Sparse and Smooth Functional Data Clustering.
\emph{arXiv preprint arXiv:2103.15224}.

Ramsay, J., Ramsay, J., & Silverman, B. W. (2005). Functional Data Analysis. Springer Science & Business Media.
}
\seealso{
\code{\link{sasfclust}}
}
