% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sascfg.R
\name{sascfg}
\alias{sascfg}
\title{Create SAS Session Configuration File}
\usage{
sascfg(
  name = "default",
  host,
  saspath,
  ssh = system("which ssh", intern = TRUE),
  encoding = "latin1",
  options = list("-fullstimer"),
  ...,
  sascfg = "sascfg_personal.py"
)
}
\arguments{
\item{name}{(\code{character})\cr name of the configuration.}

\item{host}{(\code{character})\cr host name of remote server.}

\item{saspath}{(\code{character})\cr SAS executable path on remote server.}

\item{ssh}{(\code{character})\cr executable path of ssh.}

\item{encoding}{(\code{character})\cr encoding of the SAS session.}

\item{options}{(\code{list})\cr additional list of arguments to pass to \code{ssh} command.}

\item{...}{additional arguments.}

\item{sascfg}{(\code{character})\cr target file of configuration.}
}
\value{
No return value.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Create SAS session configuration file based on argument.
}
\details{
\code{host} and \code{saspath} are required to connect to remote SAS server. Other arguments can follow default.
If transferring datasets is needed and the client(running sasr) is not reachable from the server,
then tunnelling is required.
Use \verb{tunnel = }, \verb{rtunnel = } to specify tunnels and reverse tunnels.
The values should be length 1 integer.
}
