% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sazed.R
\name{S}
\alias{S}
\title{Compute the S component of the SAZED ensemble}
\usage{
S(y, preprocess = T)
}
\arguments{
\item{y}{The input time series.}

\item{preprocess}{If true, y is detrended and z-normalized before
computation.}
}
\value{
The S season length estimate of y.
}
\description{
\code{S} computes the spectral density of its argument, and then derives the
season length from it.
}
\examples{
season_length <- 26
y <- sin(1:400*2*pi/season_length)
S(y)
S(y, preprocess = FALSE)
}
