% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{estimateBipartiteSBM}
\alias{estimateBipartiteSBM}
\title{Estimation of Bipartite SBMs}
\usage{
estimateBipartiteSBM(
  netMat,
  model = "bernoulli",
  dimLabels = c(row = "row", col = "col"),
  covariates = list(),
  estimOptions = list()
)
}
\arguments{
\item{netMat}{a matrix describing the network: either an adjacency (square) or incidence matrix with possibly weighted entries.}

\item{model}{character describing the model for the relation between nodes (\code{'bernoulli'}, \code{'poisson'}, \code{'gaussian'}, ...). Default is \code{'bernoulli'}.}

\item{dimLabels}{an optional list of labels for each dimension (in row, in column)}

\item{covariates}{a list of matrices with same dimension as mat describing covariates at the edge level. No covariate per Default.}

\item{estimOptions}{a list of parameters controlling the inference algorithm and model selection. See details.}
}
\value{
a list with the estimated parameters. See details...
}
\description{
This function performs variational inference of bipartite Stochastic Block Models, with various model
for the distribution of the edges:  Bernoulli, Poisson, or Gaussian models.
}
\details{
The list of parameters \code{estimOptions} essentially tunes the optimization process and the variational EM algorithm, with the following parameters
\itemize{
\item{"nbCores"}{integer for number of cores used. Default is 2}
\item{"verbosity"}{integer for verbosity (0, 1). Default is 1}
\item{"plot"}{boolean, should the ICL by dynamically plotted or not. Default is TRUE}
\item{"exploreFactor"}{control the exploration of the number of groups}
\item{"exploreMin"}{explore at least until exploreMin even if the exploration factor rule is achieved. Default 4. See the package blockmodels for details.}
\item{"exploreMin"}{Stop exploration at exploreMax  even if the exploration factor rule is not achieved. Default Inf. See the package blockmodels for details.}
\item{"fast"}{logical: should approximation be used for Bernoulli model with covariates. Default to \code{TRUE}}
}
}
\examples{
### =======================================
### BIPARTITE BINARY SBM (Bernoulli model)

## Graph parameters and Sampling
nbNodes <- c(60, 80)
blockProp <- list(c(.5, .5), c(1/3, 1/3, 1/3)) # group proportions
means <- matrix(runif(6), 2, 3)  # connectivity matrix
# In Bernoulli SBM, parameters is a list with a
# matrix of means 'mean' which are probabilities of connection
connectParam <- list(mean = means)
mySampler <- sampleBipartiteSBM(nbNodes, blockProp, connectParam, model = 'bernoulli')

## Estimation
myBipartiteSBM <- estimateBipartiteSBM(mySampler$networkData, estimOptions = list(plot = FALSE))
plot(myBipartiteSBM, 'expected')

### =======================================
### BIPARTITE POISSON SBM

## Graph parameters & Sampling
nbNodes <- c(60, 80)
blockProp <- list(c(.5, .5), c(1/3, 1/3, 1/3)) # group proportions
means <- matrix(rbinom(6, 30, 0.25), 2, 3)  # connectivity matrix
connectParam <- list(mean = means)
mySampler <- sampleBipartiteSBM(nbNodes, blockProp, connectParam, model = 'poisson')

## Estimation
myBipartiteSBM <-
  estimateBipartiteSBM(mySampler$networkData, 'poisson', estimOptions = list(plot = FALSE))
plot(myBipartiteSBM, 'expected')

### =======================================
### BIPARTITE GAUSSIAN SBM
## Graph parameters & sampling
nbNodes <- c(60, 80)
blockProp <- list(c(.5, .5), c(1/3, 1/3, 1/3)) # group proportions
means <- 20 * matrix(runif(6), 2, 3)  # connectivity matrix
connectParam <- list(mean = means, var = 1)
mySampler <- sampleBipartiteSBM(nbNodes, blockProp, connectParam, model = 'gaussian')

## Estimation
myBipartiteSBM <-
  estimateBipartiteSBM(mySampler$networkData, 'gaussian', estimOptions = list(plot = FALSE))
plot(myBipartiteSBM, 'expected')

}
