% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LIGER_Utilities.R
\name{Subset_LIGER}
\alias{Subset_LIGER}
\title{Subset LIGER object}
\usage{
Subset_LIGER(
  liger_object,
  cluster = NULL,
  cluster_col = "leiden_cluster",
  ident = NULL,
  ident_col = NULL,
  invert = FALSE
)
}
\arguments{
\item{liger_object}{LIGER object name.}

\item{cluster}{Name(s) of cluster to subset from object.}

\item{cluster_col}{name of \verb{@cellMeta} column containing cluster names, default is "leiden_cluster".}

\item{ident}{variable within \code{ident_col} to use in sub-setting object.}

\item{ident_col}{column in \verb{@cellMeta} that contains values provided to \code{ident}.}

\item{invert}{logical, whether to subset the inverse of the clusters or idents provided, default is FALSE.}
}
\value{
liger object
}
\description{
Subset LIGER object by cluster or other meta data variable.
}
\examples{
\dontrun{
# subset clusters 3 and 5
sub_liger <- subset_liger(liger_object = liger_object, cluster = c(3, 5))

# subset control samples from column "Treatment"
sub_liger <- subset_liger(liger_object = liger_object, ident = "control",
ident_col = "Treatment")

# subset control samples from column "Treatment" in clusters 3 and 5
sub_liger <- subset_liger(liger_object = liger_object, ident = "control",
ident_col = "Treatment", cluster = c(3, 5))

# Remove cluster 9
sub_liger <- subset_liger(liger_object = liger_object, cluster = 9, invert = TRUE)
}

}
\concept{liger_object_util}
