% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting_Statistics.R
\name{Plot_Median_Other}
\alias{Plot_Median_Other}
\title{Plot Median other variable per Cell per Sample}
\usage{
Plot_Median_Other(
  seurat_object,
  median_var,
  sample_col = "orig.ident",
  group.by = NULL,
  colors_use = NULL,
  dot_size = 1,
  plot_title = NULL,
  y_axis_label = NULL,
  x_axis_label = NULL,
  legend_title = NULL,
  x_lab_rotate = TRUE,
  color_seed = 123
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{median_var}{Variable in meta.data slot to calculate and plot median values for.}

\item{sample_col}{Specify which column in meta.data specifies sample ID (i.e. orig.ident).}

\item{group.by}{Column in meta.data slot to group results by (i.e. "Treatment").}

\item{colors_use}{List of colors or color palette to use.  Only applicable if \code{group.by} is not NULL.}

\item{dot_size}{size of the dots plotted if \code{group.by} is not NULL.  Default is 1.}

\item{plot_title}{Plot title.}

\item{y_axis_label}{Label for y axis.}

\item{x_axis_label}{Label for x axis.}

\item{legend_title}{Label for plot legend.}

\item{x_lab_rotate}{logical.  Whether to rotate the axes labels on the x-axis.  Default is FALSE.}

\item{color_seed}{random seed for the "varibow" palette shuffle if \code{colors_use = NULL} and number of
groups plotted is greater than 36.  Default = 123.}
}
\value{
A ggplot object
}
\description{
Plot of median other variable per cell per sample grouped by desired meta data variable.
}
\examples{
\dontrun{
library(Seurat)
cd_features <- list(c('CD79B', 'CD79A', 'CD19', 'CD180', 'CD200', 'CD3D', 'CD2','CD3E',
'CD7','CD8A', 'CD14', 'CD1C', 'CD68', 'CD9', 'CD247'))

pbmc_small <- AddModuleScore(object = pbmc_small, features = cd_features, ctrl = 5,
name = 'CD_Features')

Plot_Median_Other(seurat_object = pbmc_small, median_var = "CD_Features1",
sample_col = "orig.ident", group.by = "Treatment")
}

}
\concept{stats_plotting}
