% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manage_container.R
\name{make_new_container}
\alias{make_new_container}
\title{Create a container to store all data and results for the project. You must
provide a params list as generated by initialize_params(). You also need to
provide either a Seurat object or both a count_data matrix and a meta_data matrix.}
\usage{
make_new_container(
  params,
  count_data = NULL,
  meta_data = NULL,
  seurat_obj = NULL,
  scMinimal = NULL,
  gn_convert = NULL,
  metadata_cols = NULL,
  metadata_col_nm = NULL,
  label_donor_sex = FALSE
)
}
\arguments{
\item{params}{list A list of the experiment params to use as generated by
initialize_params()}

\item{count_data}{dgCMatrix Matrix of raw counts with genes as rows
and cells as columns (default=NULL)}

\item{meta_data}{data.frame Metadata with cells as rows and variables
as columns. Number of rows in metadata should equal number of columns
in count matrix (default=NULL)}

\item{seurat_obj}{Seurat object that has been cleaned and includes the normalized,
log-transformed counts. The meta.data should include a column with the header
'sex' and values of 'M' or 'F' if available. The metadata should
also have a column with the header 'ctypes' with the corresponding names of
the cell types as well as a column with header 'donors' that contains
identifiers for each donor. (default=NULL)}

\item{scMinimal}{environment A sub-container for the project typically
consisting of gene expression data in its raw and processed forms as well
as metadata (default=NULL)}

\item{gn_convert}{data.frame Gene identifier -> gene name conversions table.
Gene identifiers used in counts matrices should appear in the first column and
the corresponding gene symbols should appear in the second column. Can remain
NULL if the identifiers are already gene symbols. (default=NULL)}

\item{metadata_cols}{character The names of the metadata columns to use
(default=NULL)}

\item{metadata_col_nm}{character New names for the selected metadata columns
if wish to change their names. If NULL, then the preexisting column names are
used. (default=NULL)}

\item{label_donor_sex}{logical Set to TRUE to label donor sex in the meta data
by using expressing of sex-associated genes (default=FALSE)}
}
\value{
A project container of class environment that stores sub-containers
for each cell type as well as results and plots from all analyses.
}
\description{
Create a container to store all data and results for the project. You must
provide a params list as generated by initialize_params(). You also need to
provide either a Seurat object or both a count_data matrix and a meta_data matrix.
}
