% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell_distributions.R
\name{GenerateDistributions}
\alias{GenerateDistributions}
\title{Generate Characteristic Distributions of Cells}
\usage{
GenerateDistributions(
  spatial_data,
  positive_mean = 10,
  negative_mean = 2,
  positive_sd = 2,
  negative_sd = 1
)
}
\arguments{
\item{spatial_data}{object of either class \code{list} or \code{data.frame}. Can be created from \code{SpatSimObj} with \code{\link{CreateSpatialList}}}

\item{positive_mean, negative_mean}{number for mean of which to center the distribution of the positive and negative cell types.
Can be single number of vector with length matching number of Cells.}

\item{positive_sd, negative_sd}{number for the standard deviation around the positive cell type mean. Can be single value or same length as number of Cells.}
}
\value{
object with a class that is the same as input \code{spatial_data} with new columns containing distributions for positive/negative assigned cells
}
\description{
Generate Characteristic Distributions of Cells
}
\examples{
#create simulation object
spatial_data = CreateSimulationObject(sims = 1, cell_types = 1) \%>\%
  #produce the point pattern
  GenerateSpatialPattern() \%>\%
  #make tissues
  GenerateTissue(density_heatmap = FALSE, step_size = 0.1, cores = 1) \%>\%
  #create positive and negative cells
  GenerateCellPositivity(k = 4, sdmin = 3, sdmax = 5,
  density_heatmap = FALSE, step_size = 1, cores = 1, probs = c(0.0, 0.1), shift = 0) \%>\%
  #convert to a list of spatial data frames
  CreateSpatialList(single_df = FALSE)
spat_data_distribution = GenerateDistributions(spatial_data)
}
