% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory_inference.R
\name{scTEP.fa}
\alias{scTEP.fa}
\title{scTEP.fa}
\usage{
scTEP.fa(data, genesets, data_org = "hsa", ncores = 10L, seed = NULL)
}
\arguments{
\item{data}{A list consists of gene expression matrix.}

\item{genesets}{A list consists of Homo sapiens and Mus musculus gene sets.}

\item{data_org}{The organism of the data set, mmu or hsa.}

\item{ncores}{Number of processor cores to use. This values is set to \code{seed = 10L} by default}

\item{seed}{A parameter to set a seed for reproducibility.}
}
\value{
List with the following keys:
\itemize{
\item faData - A large matrix consists of concatenated 2 dimensional factor analysis results of pathways.
}
}
\description{
The 'scTEP.fa' function first selects the corresponding pathway gene sets of the data set from KEGG, then intersect the genes in the expression matrix with each pathway to have an intersect gene expression matrix for all pathways.
}
\examples{
# Load the package and the example data (goolam datas set)
library(scTEP)
#Load pathway genesets
data('genesets')
#Load example data (SCE dataset)
data("goolam")
#Get data matrix and label
expr <- as.matrix(t(SummarizedExperiment::assay(goolam)))[1:10, 1:100]

#Get data matrix and label
data = preprocessing(expr)

#Generate factor analysis results for all the intersections between data matrix and genesets
data_fa = scTEP.fa(data, genesets, ncores = 2, data_org = 'mmu', seed = 1)
}
