% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-number.r
\name{label_number}
\alias{label_number}
\alias{label_comma}
\alias{comma}
\alias{number_format}
\alias{comma_format}
\title{Label numbers in decimal format (e.g. 0.12, 1,234)}
\usage{
label_number(accuracy = NULL, scale = 1, prefix = "", suffix = "",
  big.mark = " ", decimal.mark = ".", trim = TRUE, ...)

label_comma(accuracy = NULL, scale = 1, prefix = "", suffix = "",
  big.mark = ",", decimal.mark = ".", trim = TRUE, digits, ...)

comma(x, accuracy = NULL, scale = 1, prefix = "", suffix = "",
  big.mark = ",", decimal.mark = ".", trim = TRUE, digits, ...)

number_format(accuracy = NULL, scale = 1, prefix = "", suffix = "",
  big.mark = " ", decimal.mark = ".", trim = TRUE, ...)

comma_format(accuracy = NULL, scale = 1, prefix = "", suffix = "",
  big.mark = ",", decimal.mark = ".", trim = TRUE, digits, ...)
}
\arguments{
\item{accuracy}{A number to round to. Use (e.g.) \code{0.01} to show 2 decimal
places of precision. If \code{NULL}, the default, uses a heuristic that should
ensure breaks have the minimum number of digits needed to show the
difference between adjacent values.

Applied to rescaled data.}

\item{scale}{A scaling factor: \code{x} will be multiplied by \code{scale} before
formating. This is useful if the underlying data is very small or very
large.}

\item{prefix, suffix}{Symbols to display before and after value.}

\item{big.mark}{Character used between every 3 digits to separate thousands.}

\item{decimal.mark}{The character to be used to indicate the numeric
decimal point.}

\item{trim}{Logical, if \code{FALSE}, values are right-justified to a common
width (see \code{\link[base:format]{base::format()}}).}

\item{...}{Other arguments passed on to \code{\link[base:format]{base::format()}}.}

\item{digits}{Deprecated, use \code{accuracy} instead.}

\item{x}{A numeric vector to format.}
}
\value{
All \code{label_()} functions return a "labelling" function, i.e. a function that
takes a vector \code{x} and returns a character vector of \code{length(x)} giving a
label for each input value.

Labelling functions are designed to be used with the \code{labels} argument of
ggplot2 scales. The examples demonstrate their use with x scales, but
they work similarly for all scales, including those that generate legends
rather than axes.
}
\description{
Use \code{label_number()} force decimal display of numbers (i.e. don't use
\link[=label_scientific]{scientific} notation). \code{label_comma()} is a special case
that inserts a comma every three digits.
}
\section{Old interface}{

\code{number_format()}, \code{comma_format()}, and \code{comma()} are retired; please use
\code{label_number()} and \code{label_comma()} instead.
}

\examples{
demo_continuous(c(-1e6, 1e6))
demo_continuous(c(-1e6, 1e6), labels = label_number())
demo_continuous(c(-1e6, 1e6), labels = label_comma())

# Use scale to rescale very small or large numbers to generate
# more readable labels
demo_continuous(c(0, 1e6), labels = label_number())
demo_continuous(c(0, 1e6), labels = label_number(scale = 1 / 1e3))
demo_continuous(c(0, 1e-6), labels = label_number())
demo_continuous(c(0, 1e-6), labels = label_number(scale = 1e6))

# You can use prefix and suffix for other types of display
demo_continuous(c(32, 212), label = label_number(suffix = "\\u00b0F"))
demo_continuous(c(0, 100), label = label_number(suffix = "\\u00b0C"))
}
