% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCALPEL_graphics.R
\name{plotCluster}
\alias{plotCluster}
\title{Plot a summary of a given cluster from Step 2 of SCALPEL.}
\usage{
plotCluster(
  scalpelOutput,
  AIndex = NULL,
  AfilterIndex = NULL,
  pctTransp = 0.01
)
}
\arguments{
\item{scalpelOutput}{An object returned by one of the SCALPEL functions:
\code{\link{scalpel}}, \code{\link{scalpelStep2}}, or \code{\link{scalpelStep3}}.}

\item{AIndex}{The dictionary element (i.e., cluster) of interest. The index refers to the column of \code{scalpelOutput$A}, which is part
of the output from \code{\link{scalpelStep2}}. Specify \code{AIndex} or \code{AfilterIndex}, not both.}

\item{AfilterIndex}{The refined dictionary element of interest. The index refers to the column of \code{scalpelOutput$Afilter}, which is part
of the output from \code{\link{scalpelStep3}}. Note that the
class of \code{scalpelOutput} must be \code{scalpel} or \code{scalpelStep3} if specifying \code{AfilterIndex}. Specify \code{AIndex} or \code{AfilterIndex}, not both.}

\item{pctTransp}{The percent transparency (in [0,1]) for the colors used to plot the preliminary dictionary elements. The default value is 0.01.}
}
\value{
None
}
\description{
We plot the preliminary dictionary elements that correspond to a given dictionary element, derived during Step 2 of SCALPEL, or a
given component included in the sparse group lasso of Step 3.
}
\details{
The left plot shows the dictionary element of interest in orange, with the other dictionary elements
 shown in blue. The middle plot shows all of the preliminary dictionary elements corresponding to the
dictionary element plotted transparently. The right plot shows the dictionary element in orange, along with
the union of all of the preliminary dictionary elements in gray. Note that the plots in the middle and on the right are
zoomed-in, compared to the plot on the left that shows the entire field of view for the video.
}
\examples{
\dontrun{
### many of the functions in this package are interconnected so the
### easiest way to learn to use the package is by working through the vignette,
### which is available at ajpete.com/software

#assumes you have run the example for the "scalpel" function
#plots the cluster for the 2nd dictionary element (i.e., scalpelOutput$A[,2])
plotCluster(scalpelOutput = scalpelOutput, AIndex = 2)
#plots the cluster for the 2nd component included in SGL (i.e., scalpelOutput$Afilter[,2])
plotCluster(scalpelOutput = scalpelOutput, AfilterIndex = 2)
}
}
\seealso{
\code{\link{scalpelStep2}}, \code{\link{scalpel}}
}
