% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{anova.sc_plm}
\alias{anova.sc_plm}
\alias{anova.sc_hplm}
\alias{anova.sc_mplm}
\title{ANOVA Table for Piecewise Linear Models}
\usage{
\method{anova}{sc_plm}(object, ...)

\method{anova}{sc_hplm}(object, ...)

\method{anova}{sc_mplm}(object, ...)
}
\arguments{
\item{object}{an object containing the results returned by a plm().}

\item{...}{additional plm objects.}
}
\description{
Model comparison for piecewise regression models
}
\examples{
## For glm models with family = "gaussian"
mod1 <- plm(exampleAB$Johanna, level = FALSE, slope = FALSE)
mod2 <- plm(exampleAB$Johanna)
anova(mod1, mod2)
## For glm models with family = "poisson"
mod0 <- plm(example_A24, formula = injuries ~ 1, family = "poisson")
mod1 <- plm(example_A24, trend = FALSE, family = "poisson")
anova(mod0, mod1, mod2)
## For glm with family = "binomial"
mod0 <- plm(
  exampleAB_score$Christiano, 
  formula = values ~ 1, 
  family = "binomial", 
  var_trials = "trials"
)
mod1 <- plm(
  exampleAB_score$Christiano, 
  trend = FALSE, 
  family = "binomial", 
  var_trials = "trials"
)
anova(mod0, mod1)
## For multilevel models:
mod0 <- hplm(Leidig2018, trend = FALSE, slope = FALSE, level = FALSE)
mod1 <- hplm(Leidig2018, trend = FALSE)
mod2 <- hplm(Leidig2018)
anova(mod0, mod1, mod2)
## For mplm
mod0 <- mplm(
  Leidig2018$`1a1`, 
  update = . ~  1, dvar = c("academic_engagement", "disruptive_behavior")
)
mod1 <- mplm(
  Leidig2018$`1a1`, 
  trend = FALSE, 
  dvar = c("academic_engagement", "disruptive_behavior")
)
mod2 <- mplm(
  Leidig2018$`1a1`, 
  dvar = c("academic_engagement", "disruptive_behavior")
)

anova(mod0, mod1, mod2)
}
