% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_poisson.R
\name{poisson_statistic}
\alias{poisson_statistic}
\title{Calculate the expectation-based Poisson statistic for each space-time window.}
\usage{
poisson_statistic(table)
}
\arguments{
\item{table}{A \code{data.table} with columns \code{zone, duration, count,
mu, relrisk}. The columns \code{count} and \code{mu} contain the sums
of the counts and mus for the locations inside each zone and up to the
given duration. The column \code{relrisk} contains the maximum likelihood
estimate for the relative risk for each zone-duration combination.}
}
\value{
A \code{data.table} with columns \code{zone, duration, statistic}.
   The column \code{statistic} contains the logarithm of the statistic for 
   each zone-duration combination.
}
\description{
This function calculates the logarithm of the expectation-based Poisson 
statistic for each space-time window, given already calculated relative risks
and aggregate counts and mus.
}
\keyword{internal}

