% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterPlotMatrix.R
\name{setCategoricalColorScale}
\alias{setCategoricalColorScale}
\title{Tells which color scale to use for categorical columns.}
\usage{
setCategoricalColorScale(id, categoricalCsId)
}
\arguments{
\item{id}{Output variable to read from (id which references the requested plot).}

\item{categoricalCsId}{One of the available color scale ids (Category10, Accent, Dark2, Paired, Set1).}
}
\value{
No return value, called from shiny applications for side effects.
}
\description{
Tells which color scale to use for categorical columns.
}
\examples{
 if(interactive()) {
   library(shiny)
   library(scatterPlotMatrix)

   ui <- fluidPage(
     selectInput(
       "categoricalCsSelect", 
       "Categorical Color Scale:", 
       choices = list(
         "Category10" = "Category10", "Accent" = "Accent", "Dark2" = "Dark2", 
         "Paired" = "Paired", "Set1" = "Set1"
       ), 
       selected = "Category10"
     ),
     p("The selector controls the colors used when reference column is of type categorical"),
     scatterPlotMatrixOutput("spMatrix")
   )

   server <- function(input, output, session) {
     output$spMatrix <- renderScatterPlotMatrix({
       scatterPlotMatrix(iris, zAxisDim = "Species")
     })
     observeEvent(input$categoricalCsSelect, {
       scatterPlotMatrix::setCategoricalColorScale("spMatrix", input$categoricalCsSelect)
     })
   }

   shinyApp(ui, server)
 }

}
