% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scattermore.R
\name{scattermoreplot}
\alias{scattermoreplot}
\title{scattermoreplot}
\usage{
scattermoreplot(x, y, xlim, ylim, size, col = grDevices::rgb(0, 0, 0, 1),
  cex = 0, xlab, ylab, ...)
}
\arguments{
\item{x, y, xlim, ylim, xlab, ylab, ...}{used as in \code{\link[graphics:plot]{graphics::plot()}} or forwarded to \code{\link[graphics:plot]{graphics::plot()}}}

\item{size}{forwarded to \code{\link[=scattermore]{scattermore()}}, or auto-derived from device and plot size if missing (the estimate is not pixel-perfect on most devices, but gets pretty close)}

\item{col}{point color(s)}

\item{cex}{forwarded to \code{\link[=scattermore]{scattermore()}}}
}
\description{
Convenience base-graphics-like layer around scattermore. Currently only works with linear axes!
}
\examples{
# plot an actual rainbow
library(scattermore)
d <- data.frame(s=qlogis(1:1e7/(1e7+1), 6, 0.5), t=rnorm(1e7, pi/2, 0.5))
scattermoreplot(
  d$s*cos(d$t),
  d$s*sin(d$t),
  col=rainbow(1e7, alpha=.01)[c((9e6+1):1e7, 1:9e6)],
  main="scattermore demo")
}
