% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color-spaces.R
\name{lab_to_rgb}
\alias{lab_to_rgb}
\title{Convert from Lab space into RGB colour channels.}
\usage{
lab_to_rgb(lab, transformation = "sRGB", linear_func = NULL)
}
\arguments{
\item{lab}{A dataframe or matrix with L, a and b colour channels located in the columns 1 to 3, respectively.}

\item{transformation}{An option in \code{c("sRGB", "Adobe")} for a built-in transformation or, alternatively, a custom 3x3 transformation matrix.}

\item{linear_func}{A function to convert RGB colour space into non-linear RGB space. Used only if a custom transformation matrix is provided. Transformation skips if no function is provided under a user-defined transformation matrix. See: https://en.wikipedia.org/wiki/SRGB.}
}
\value{
A \code{tibble} of red, green and blue colour channels.
}
\description{
Convert from Lab space into RGB colour channels.
}
\examples{
red <- sample(x = 1:255, size = 10, replace = TRUE)
green <- sample(x = 1:255, size = 10, replace = TRUE)
blue <- sample(x = 1:255, size = 10, replace = TRUE)
lab_to_rgb(rgb_to_lab(data.frame(r = red, g = green, b = blue)))
}
