% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotCD}
\alias{plotCD}
\title{Critical difference plot}
\usage{
plotCD(results.matrix, alpha = 0.05, cex = 0.75, ...)
}
\arguments{
\item{results.matrix}{Matrix or data frame with the results for each algorithm}

\item{alpha}{Significance level to get the critical difference. By default this value is 0.05}

\item{cex}{Numeric value to control the size of the font. By default it is set at 0.75.}

\item{...}{Additional arguments for \code{\link{rankMatrix}}}
}
\description{
This function plots the critical difference plots shown in Demsar (2006)
}
\examples{
data(data_gh_2008)
plotCD(data.gh.2008, alpha=0.01)
}
\references{
Demsar, J. (2006) Statistical Comparisons of Classifiers over Multiple Data Sets. \emph{Journal of Machine Learning Research}, 7, 1-30.
}
\seealso{
\code{\link{drawAlgorithmGraph}}, \code{\link{plotPvalues}}
}

