% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{hierarchicalClones}
\alias{hierarchicalClones}
\title{Hierarchical clustering-based method for partitioning Ig sequences into clones.}
\usage{
hierarchicalClones(
  db,
  threshold,
  method = c("nt", "aa"),
  linkage = c("single", "average", "complete"),
  normalize = c("len", "none"),
  junction = "junction",
  v_call = "v_call",
  j_call = "j_call",
  clone = "clone_id",
  first = FALSE,
  cdr3 = FALSE,
  mod3 = FALSE,
  max_n = 0,
  nproc = 1,
  verbose = FALSE,
  log = NULL,
  summarize_clones = TRUE
)
}
\arguments{
\item{db}{data.frame containing sequence data.}

\item{threshold}{a numeric scalar where the tree should be cut (the distance threshold for clonal grouping).}

\item{method}{one of the \code{"nt"} for nucleotide based clustering or 
\code{"aa"} for amino acid based clustering.}

\item{linkage}{available linkage are \code{"single"}, \code{"average"}, and \code{"complete"}.}

\item{normalize}{method of normalization. The default is \code{"len"}, which divides the distance by the length 
of the sequence group. If \code{"none"} then no normalization if performed.}

\item{junction}{character name of the column containing junction sequences.
Also used to determine sequence length for grouping.}

\item{v_call}{character name of the column containing the V-segment allele calls.}

\item{j_call}{character name of the column containing the J-segment allele calls.}

\item{clone}{the output column name containing the clonal cluster identifiers.}

\item{first}{specifies how to handle multiple V(D)J assignments for initial grouping. 
If \code{TRUE} only the first call of the gene assignments is used. 
If \code{FALSE} the union of ambiguous gene assignments is used to 
group all sequences with any overlapping gene calls.}

\item{cdr3}{if \code{TRUE} removes 3 nucleotides from both ends of \code{"junction"} 
prior to clustering (converts IMGT junction to CDR3 region). 
If \code{TRUE} this will also remove records with a junction length 
less than 7 nucleotides.}

\item{mod3}{if \code{TRUE} removes records with a \code{junction} length that is not divisible by 
3 in nucleotide space.}

\item{max_n}{The maximum number of \code{N} characters to permit in the junction sequence 
before excluding the record from clonal assignment. Note, with 
\code{linkage="single"} non-informative positions can create artifactual 
links between unrelated sequences. Use with caution. 
Default is set to be zero. Set it as \code{"NULL"} for no action.}

\item{nproc}{number of cores to distribute the function over.}

\item{verbose}{if \code{TRUE} prints out a summary of each step cloning process.
if \code{FALSE} (default) process cloning silently.}

\item{log}{output path and filename to save the \code{verbose} log. 
The input file directory is used if path is not specified.
The default is \code{NULL} for no action.}

\item{summarize_clones}{if \code{TRUE} performs a series of analysis to assess the clonal landscape
and returns a \link{ScoperClones} object. If \code{FALSE} then
a modified input \code{db} is returned.}
}
\value{
If \code{summarize_clones=TRUE} (default) a \link{ScoperClones} object is returned that includes the 
clonal assignment summary information and a modified input \code{db} in the \code{db} slot that 
contains clonal identifiers in the specified \code{clone} column.
If \code{summarize_clones=FALSE} modified \code{data.frame} is returned with clone identifiers in the 
specified \code{clone} column.
}
\description{
The \code{hierarchicalClones} function provides a computational pipline for assigning Ig 
sequences into clonal groups sharing same V gene, J gene, and junction length, based on the 
junction sequence similarity.
}
\details{
\code{hierarchicalClones} provides a computational platform to explore the B cell clonal 
relationships in high-throughput Adaptive Immune Receptor Repertoire sequencing (AIRR-seq) 
data sets. This function performs hierarchical clustering among sequences of B cell receptors 
(BCRs, immunoglobulins, Ig) that share the same V gene, J gene, and junction length 
based on the junction sequence similarity:
}
\examples{
# Find clonal groups
results <- hierarchicalClones(ExampleDb, threshold=0.15)

# Retrieve modified input data with clonal clustering identifiers
df <- as.data.frame(results)

# Plot clonal summaries 
plot(results, binwidth=0.02)

}
\seealso{
See \link{plotCloneSummary} plotting summary results.
}
