% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{hierarchicalClones}
\alias{hierarchicalClones}
\title{Hierarchical clustering method for clonal partitioning}
\usage{
hierarchicalClones(
  db,
  threshold,
  method = c("nt", "aa"),
  linkage = c("single", "average", "complete"),
  normalize = c("len", "none"),
  junction = "junction",
  v_call = "v_call",
  j_call = "j_call",
  clone = "clone_id",
  cell_id = NULL,
  locus = "locus",
  only_heavy = TRUE,
  split_light = TRUE,
  first = FALSE,
  cdr3 = FALSE,
  mod3 = FALSE,
  max_n = 0,
  nproc = 1,
  verbose = FALSE,
  log = NULL,
  summarize_clones = TRUE
)
}
\arguments{
\item{db}{data.frame containing sequence data.}

\item{threshold}{a numeric scalar where the tree should be cut (the distance threshold for clonal grouping).}

\item{method}{one of the \code{"nt"} for nucleotide based clustering or 
\code{"aa"} for amino acid based clustering.}

\item{linkage}{available linkage are \code{"single"}, \code{"average"}, and \code{"complete"}.}

\item{normalize}{method of normalization. The default is \code{"len"}, which divides the distance by the length 
of the sequence group. If \code{"none"} then no normalization if performed.}

\item{junction}{character name of the column containing junction sequences.
Also used to determine sequence length for grouping.}

\item{v_call}{character name of the column containing the V-segment allele calls.}

\item{j_call}{character name of the column containing the J-segment allele calls.}

\item{clone}{the output column name containing the clonal cluster identifiers.}

\item{cell_id}{name of the column containing cell identifiers or barcodes. 
If specified, grouping will be performed in single-cell mode
with the behavior governed by the \code{locus} and 
\code{only_heavy} arguments. If set to \code{NULL} then the 
bulk sequencing data is assumed.}

\item{locus}{name of the column containing locus information. 
Only applicable to single-cell data.
Ignored if \code{cell_id=NULL}.}

\item{only_heavy}{use only the IGH (BCR) or TRB/TRD (TCR) sequences 
for grouping. Only applicable to single-cell data.
Ignored if \code{cell_id=NULL}.}

\item{split_light}{split clones by light chains. Ignored if \code{cell_id=NULL}.}

\item{first}{specifies how to handle multiple V(D)J assignments for initial grouping. 
If \code{TRUE} only the first call of the gene assignments is used. 
If \code{FALSE} the union of ambiguous gene assignments is used to 
group all sequences with any overlapping gene calls.}

\item{cdr3}{if \code{TRUE} removes 3 nucleotides from both ends of \code{"junction"} 
prior to clustering (converts IMGT junction to CDR3 region). 
If \code{TRUE} this will also remove records with a junction length 
less than 7 nucleotides.}

\item{mod3}{if \code{TRUE} removes records with a \code{junction} length that is not divisible by 
3 in nucleotide space.}

\item{max_n}{The maximum number of \code{N} characters to permit in the junction sequence 
before excluding the record from clonal assignment. Note, with 
\code{linkage="single"} non-informative positions can create artifactual 
links between unrelated sequences. Use with caution. 
Default is set to be zero. Set it as \code{"NULL"} for no action.}

\item{nproc}{number of cores to distribute the function over.}

\item{verbose}{if \code{TRUE} prints out a summary of each step cloning process.
if \code{FALSE} (default) process cloning silently.}

\item{log}{output path and filename to save the \code{verbose} log. 
The input file directory is used if path is not specified.
The default is \code{NULL} for no action.}

\item{summarize_clones}{if \code{TRUE} performs a series of analysis to assess the clonal landscape
and returns a \link{ScoperClones} object. If \code{FALSE} then
a modified input \code{db} is returned.}
}
\value{
If \code{summarize_clones=TRUE} (default) a \link{ScoperClones} object is returned that includes the 
clonal assignment summary information and a modified input \code{db} in the \code{db} slot that 
contains clonal identifiers in the specified \code{clone} column.
If \code{summarize_clones=FALSE} modified \code{data.frame} is returned with clone identifiers in the 
specified \code{clone} column.
}
\description{
\code{hierarchicalClones} provides a hierarchical agglomerative clustering 
approach to infer clonal relationships in high-throughput Adaptive Immune Receptor 
Repertoire sequencing (AIRR-seq) data. This approach clusters B or T cell receptor 
sequences based on junction region sequence similarity within partitions that share the 
same V gene, J gene, and junction length, allowing for ambiguous V or J gene annotations.
}
\section{Single-cell data}{

To invoke single-cell mode the \code{cell_id} argument must be specified and the \code{locus} 
column must be correct. Otherwise, clustering will be performed with bulk sequencing assumptions, 
using all input sequences regardless of the values in the \code{locus} column.

Values in the \code{locus} column must be one of \code{c("IGH", "IGI", "IGK", "IGL")} for BCR 
or \code{c("TRA", "TRB", "TRD", "TRG")} for TCR sequences. Otherwise, the operation will exit and 
return and error message.

Under single-cell mode with paired-chain sequences, there is a choice of whether 
grouping should be done by (a) using IGH (BCR) or TRB/TRD (TCR) sequences only or
(b) using IGH plus IGK/IGL (BCR) or TRB/TRD plus TRA/TRG (TCR) sequences. 
This is governed by the \code{only_heavy} argument. There is also choice as to whether 
inferred clones should be split by the light/short chain (IGK, IGL, TRA, TRG) following 
heavy/long chain clustering, which is governed by the \code{split_light} argument.

In single-cell mode, clonal clustering will not be performed on data were cells are 
assigned multiple heavy/long chain sequences (IGH, TRB, TRD). If observed, the operation 
will exit and return an error message. Cells that lack a heavy/long chain sequence (i.e., cells with 
light/short chains only) will be assigned a \code{clone_id} of \code{NA}.
}

\examples{
# Find clonal groups
results <- hierarchicalClones(ExampleDb, threshold=0.15)

# Retrieve modified input data with clonal clustering identifiers
df <- as.data.frame(results)

# Plot clonal summaries 
plot(results, binwidth=0.02)

}
\seealso{
See \link{plotCloneSummary} for plotting summary results. See \link{groupGenes} for 
more details about grouping requirements.
}
