% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{support_vector_parameters}
\alias{support_vector_parameters}
\title{Hyperparameter optimisation or parameter tuning for Suppert Vector Machine by grid search}
\usage{
support_vector_parameters(base, target, scale = T, kernel, degree = 2,
  gamma, cost, error = "rmse", cv = 1)
}
\arguments{
\item{base}{input dataframe}

\item{target}{column / field name for the target variable to be passed as string (must be 0/1 type)}

\item{scale}{(optional) logical vector indicating the variables to be scaled (default value is TRUE)}

\item{kernel}{an array of kernels to be iterated on; kernel used in training and predicting, to be cheosen among "linear", "polynomial", "radial" and "sigmoid"}

\item{degree}{(optional) an array of degree of polynomial to be iterated on; parameter needed for kernel of type "polynomial" (default value is 2)}

\item{gamma}{an array of gamma values to be iterated on; parameter needed for all kernels except linear}

\item{cost}{an array of cost to be iterated on; cost of constraints violation}

\item{error}{(optional) error measure as objective function to be minimised, to be chosen among "mae", "mse" and "rmse" (default value is "rmse")}

\item{cv}{(optional) k vakue for k-fold cross validation to be performed (default value is 1 ie. without cross validation)}
}
\value{
An object of class "support_vector_parameters" is a list containing the following components:

\item{error_tab_detailed}{error summary for each cross validation sample of the parameter combinations iterated during grid search as a dataframe}

\item{error_tab_summary}{error summary for each combination of parameters as a dataframe}

\item{best_kernel}{kernel parameter of the optimal solution}

\item{best_degree}{degree parameter of the optimal solution}

\item{best_gamma}{gamma parameter of the optimal solution}

\item{best_cost}{cost parameter of the optimal solution}

\item{runtime}{runtime of the entire process}
}
\description{
The function runs a grid search with k-fold cross validation to arrive at best parameter decided by some performance measure. The parameters that can be tuned using this function for support vector machine algorithm are - kernel (linear / polynomial / radial / sigmoid), degree of polynomial, gamma and cost. The objective function to be minimised is the error (mean absolute error / mean squared error / root mean squared error). For the grid search, the possible values of each tuning parameter needs to be passed as an array into the function.
}
\examples{
data <- iris
set.seed(11)
data$Y <- sample(0:1,size=nrow(data),replace=TRUE)
svm_params_list <- support_vector_parameters(base = data,target = "Y",gamma = 0.1,
                   cost = 0.1,kernel = "radial")
svm_params_list$error_tab_detailed
svm_params_list$error_tab_summary
svm_params_list$best_kernel
svm_params_list$best_degree
svm_params_list$best_gamma
svm_params_list$best_cost
svm_params_list$runtime
}
\author{
Arya Poddar <aryapoddar290990@gmail.com>
}
