% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ADFun.R
\name{ADFun}
\alias{ADFun}
\title{A Class for Storing a CppAD Tape (ADFun) Object}
\description{
\emph{This is a low level object useful for implementing score matching estimators.}
An \code{R6} class for storing a 'pointer' to a \code{CppAD} tape in \verb{C++} (also called an \code{ADFun}) and associated information.
Currently tools for modifying this information are not available in this package, however tools for creating new \code{ADFun} objects from an existing \code{ADFun} are available.
Typically an \code{ADFun} object will be created by \code{\link[=buildsmdtape]{buildsmdtape()}}.
}
\section{Introduction to CppAD Tapes}{
This package uses version 2022000.2 of the algorithmic differentiation library \code{CppAD} \insertCite{bell2023cp}{scorematchingad} to build score matching estimators.
Full help for \code{CppAD} can be found at \url{https://cppad.readthedocs.io/}.

Differentiation proceeds by \emph{taping} the basic (\emph{atomic}) operations performed on the independent variables and dynamic parameters. The atomic operations include multiplication, division, addition, sine, cosine, exponential and many more.
Example values for the variables and parameters are used to conduct this taping, so care must be taken with any conditional (e.g. if-then) operations, and \code{CppAD} has \href{https://cppad.readthedocs.io/latest/CondExp.html}{special tools for this}.
The result of taping is an \href{https://cppad.readthedocs.io/latest/ADFun.html}{\code{ADFun}} object, often called a \emph{tape}.
This \code{ADFun} object can be evaluated, differentiated, used for further taping (see \href{https://cppad.readthedocs.io/latest/base2ad.html}{base2ad}), solving differential equations and more.
The differentiation is with respect to the independent variables, however the dynamic parameters can be altered which allows for creating a new \code{ADFun} object where the dynamic parameters become independent variables (see \code{\link[=tapeSwap]{tapeSwap()}}).
For the purposes of score matching, there are also \emph{fixed} parameters, which are the elements of the model's parameter vector that are given and not estimated.
}

\section{Warning: multiple CPU}{
Each time a tape is evaluated the corresponding \verb{C++} object is altered. Parallel use of the same \code{ADFun} object thus requires care and is not tested. For now I recommend creating a new \code{ADFun} object for each CPU.
}

\examples{
tapes <- buildsmdtape(
  "sim", "sqrt", "sph",
  ll = "ppi",
  ytape =  rep(1/3, 3),
  usertheta = ppi_paramvec(p=3),
  bdryw = "minsq",
  acut = 0.01,
  verbose = FALSE)
tapes$smdtape$xtape
tapes$smdtape$dyntape
tapes$smdtape$name
tapes$smdtape$ptr
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{ptr}}{A \code{Rcpp} external pointer to a \code{CppAD} \code{ADFun} object.}

\item{\code{xtape}}{The (numeric) vector of independent variable values used for taping.}

\item{\code{dyntape}}{The (numeric) vector of dynamic parameters used for taping.}

\item{\code{usertheta}}{A (numeric) vector of \code{NA} values and fixed values specifying the parameters of taped function that were considered dynamic parameters or fixed parameters respectively.}

\item{\code{name}}{An easy to read name for the taped function}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ADFun-new}{\code{ADFun$new()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ADFun-new"></a>}}
\if{latex}{\out{\hypertarget{method-ADFun-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{ADFun} object from an external pointer to a \code{CppAD} \code{ADFun} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ADFun$new(
  ptr,
  name = NULL,
  xtape = vector("numeric"),
  dyntape = vector("numeric"),
  usertheta = rep(NA_real_, length(dyntape))
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ptr}}{A \code{Rcpp} external pointer to a \code{CppAD} \code{ADFun} object.}

\item{\code{name}}{An easy to read name for the taped function}

\item{\code{xtape}}{The (numeric) vector of independent variables used for taping.}

\item{\code{dyntape}}{The (numeric) vector of dynamic parameters used for taping.}

\item{\code{usertheta}}{A (numeric) vector of \code{NA} values and fixed values specifying the inputs of the taped function that were considered independent variables or dynamic parameters respectively.}
}
\if{html}{\out{</div>}}
}
}
}
