% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mixnorm.R
\name{scores_mixnorm}
\alias{scores_mixnorm}
\alias{crps_mixnorm}
\alias{crps_mixnorm_int}
\alias{logs_mixnorm}
\title{Calculating scores for a mixture of normal distributions.}
\usage{
crps_mixnorm(y, m, s, w)

crps_mixnorm_int(y, m, s, w, rel_tol = 1e-06)

logs_mixnorm(y, m, s, w)
}
\arguments{
\item{y}{vector of observations.}

\item{m}{matrix of mean parameters (rows represent observations, columns represent mixture components).}

\item{s}{matrix of scale parameters (same structure as for \code{m}).}

\item{w}{matrix of weights (same structure as for \code{m}; row sums must equal one).}

\item{rel_tol}{relative accuracy for numerical integration.}
}
\value{
A vector of score values.
}
\description{
Calculating scores for a mixture of normal distributions.
}
\details{
\code{logs_mixnorm} and \code{crps_mixnorm} calculate scores via analytical formulas. \code{crps_mixnorm_int} uses numerical integration for the CRPS; this can be faster if there are many mixture components (i.e., if \code{m}, \code{s} and \code{w} have many columns). See examples below.
}
\examples{

# Example 1: 100 observations, 15 mixture components
mval <- matrix(rnorm(100*15), nrow = 100)
sdval <- matrix(rgamma(100*15, shape = 2), nrow = 100)
weights <- matrix(rep(1/15, 100*15), nrow = 100)
y <- rnorm(100)
crps1 <- crps_mixnorm(y = y, m = mval, s = sdval, w = weights)
crps2 <- crps_mixnorm_int(y = y, m = mval, s = sdval, w = weights)

\dontrun{
# Example 2: 2 observations, 10000 mixture components
mval <- matrix(rnorm(2*10000), nrow = 2)
sdval <- matrix(rgamma(2*10000, shape = 2), nrow = 2)
weights <- matrix(rep(1/10000, 2*10000), nrow = 2)
y <- rnorm(2)
# With many mixture components, numerical integration is much faster
system.time(crps1 <- crps_mixnorm(y = y, m = mval, s = sdval, w = weights))
system.time(crps2 <- crps_mixnorm_int(y = y, m = mval, s = sdval, w = weights))
}
}
