% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reclassification.R
\name{reclassification}
\alias{reclassification}
\title{Reclassification}
\usage{
reclassification(xf, xnf, yf, thresh = 0.5)
}
\arguments{
\item{xf}{The matrix of financed clients' characteristics to be used in the scorecard.}

\item{xnf}{The matrix of not financed clients' characteristics to be used in the scorecard (must be the same in the same order as xf!).}

\item{yf}{The matrix of financed clients' labels}

\item{thresh}{The threshold to use in the Classification step, i.e. the probability above which a not financed client is considered to have a label equal to 1.}
}
\value{
List containing the model using financed clients only and the model produced using the Reclassification method.
}
\description{
This function performs Reject Inference using the Reclassification technique. Note that this technique has no theoretical foundation as it performs a one-step CEM algorithm.
}
\details{
This function performs the Reclassification method on the data. When provided with labeled observations \eqn{(x^\ell,y)}, it first fits the logistic regression model \eqn{p_\theta} of
\eqn{x^\ell} on \eqn{y}, then considers that unlabeled observations are of the expected class given by the model \eqn{p_\theta} (this is equivalent to a CEM algorithm).
It then refits a logistic regression model \eqn{p_\eta} on the whole sample.
}
\examples{
# We simulate data from financed clients
xf <- matrix(runif(100 * 2), nrow = 100, ncol = 2)
theta <- c(2, -2)
log_odd <- apply(xf, 1, function(row) theta \%*\% row)
yf <- rbinom(100, 1, 1 / (1 + exp(-log_odd)))
# We simulate data from not financed clients (MCAR mechanism)
xnf <- matrix(runif(100 * 2), nrow = 100, ncol = 2)
reclassification(xf, xnf, yf)
}
\references{
Enea, M. (2015), speedglm: Fitting Linear and Generalized Linear Models to Large Data Sets, \url{https://CRAN.R-project.org/package=speedglm}
Ehrhardt, A., Biernacki, C., Vandewalle, V., Heinrich, P. and Beben, S. (2018), Reject Inference Methods in Credit Scoring: a rational review,
}
\seealso{
\code{glm}, \code{speedglm}
}
\author{
Adrien Ehrhardt
}
\keyword{credit}
\keyword{inference}
\keyword{reject}
\keyword{réintégration}
\keyword{scorecard}
\keyword{scoring}
