% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/absolute_error.R
\name{abs_error}
\alias{abs_error}
\title{Absolute Error}
\usage{
abs_error(true_values, predictions)
}
\arguments{
\item{true_values}{A vector with the true observed values of size n}

\item{predictions}{numeric vector with predictions, corresponding to the
quantiles in a second vector, `quantiles`.}
}
\value{
vector with the absolute error
}
\description{
Caclulate absolute error as

\deqn{
  abs(true_value - prediction)
}
}
\examples{
true_values <- rnorm(30, mean = 1:30)
predicted_values <- rnorm(30, mean = 1:30)
abs_error(true_values, predicted_values)
}
