% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-sample.R
\name{dss_sample}
\alias{dss_sample}
\title{Dawid-Sebastiani score}
\usage{
dss_sample(observed, predicted, ...)
}
\arguments{
\item{observed}{A vector with observed values of size n}

\item{predicted}{nxN matrix of predictive samples, n (number of rows) being
the number of data points and N (number of columns) the number of Monte
Carlo samples. Alternatively, \code{predicted} can just be a vector of size n.}

\item{...}{Additional arguments passed to
\link[scoringRules:scores_sample_univ]{dss_sample()} from the scoringRules package.}
}
\value{
Vector with scores.
}
\description{
Wrapper around the \code{\link[scoringRules:scores_sample_univ]{dss_sample()}}
function from the
\pkg{scoringRules} package.
}
\section{Input format}{
\if{html}{
  \out{<div style="text-align: left">}
  \figure{metrics-sample.png}{options: style="width:750px;max-width:100\%;"}
  \out{</div><p>}
  Overview of required input format for sample-based forecasts
}
\if{latex}{
  \figure{metrics-sample.png}
}
}

\examples{
observed <- rpois(30, lambda = 1:30)
predicted <- replicate(200, rpois(n = 30, lambda = 1:30))
dss_sample(observed, predicted)
}
\references{
Alexander Jordan, Fabian Krüger, Sebastian Lerch, Evaluating Probabilistic
Forecasts with scoringRules, \url{https://www.jstatsoft.org/article/view/v090i12}
}
\keyword{metric}
