% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-forecast-counts.R
\name{get_forecast_counts}
\alias{get_forecast_counts}
\title{Count number of available forecasts}
\usage{
get_forecast_counts(
  forecast,
  by = get_forecast_unit(forecast),
  collapse = c("quantile_level", "sample_id")
)
}
\arguments{
\item{forecast}{A forecast object (a validated data.table with predicted and
observed values).}

\item{by}{character vector or \code{NULL} (the default) that denotes the
categories over which the number of forecasts should be counted.
By default this will be the unit of a single forecast (i.e.
all available columns (apart from a few "protected" columns such as
'predicted' and 'observed') plus "quantile_level" or "sample_id" where
present).}

\item{collapse}{character vector (default: \verb{c("quantile_level", "sample_id"})
with names of categories for which the number of rows should be collapsed
to one when counting. For example, a single forecast is usually represented
by a set of several quantiles or samples and collapsing these to one makes
sure that a single forecast only gets counted once. Setting
\code{collapse = c()} would mean that all quantiles / samples would be counted
as individual forecasts.}
}
\value{
A data.table with columns as specified in \code{by} and an additional
column "count" with the number of forecasts.
}
\description{
Given a data set with forecasts, this function counts the number of
available forecasts.
The level of grouping can be specified using the \code{by} argument (e.g. to
count the number of forecasts per model, or the number of forecasts per
model and location).
This is useful to determine whether there are any missing forecasts.
}
\examples{
\dontshow{
  data.table::setDTthreads(2) # restricts number of cores used on CRAN
}

library(magrittr) # pipe operator
example_quantile \%>\%
  as_forecast_quantile() \%>\%
  get_forecast_counts(by = c("model", "target_type"))
}
\keyword{gain-insights}
