% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-forecast-point.R,
%   R/class-forecast-quantile.R
\name{as_forecast_point}
\alias{as_forecast_point}
\alias{as_forecast_point.default}
\alias{as_forecast_point.forecast_quantile}
\title{Create a \code{forecast} object for point forecasts}
\usage{
as_forecast_point(data, ...)

\method{as_forecast_point}{default}(
  data,
  forecast_unit = NULL,
  observed = NULL,
  predicted = NULL,
  ...
)

\method{as_forecast_point}{forecast_quantile}(data, ...)
}
\arguments{
\item{data}{A data.frame (or similar) with predicted and observed values.
See the details section of for additional information
on the required input format.}

\item{...}{Unused}

\item{forecast_unit}{(optional) Name of the columns in \code{data} (after
any renaming of columns) that denote the unit of a
single forecast. See \code{\link[=get_forecast_unit]{get_forecast_unit()}} for details.
If \code{NULL} (the default), all columns that are not required columns are
assumed to form the unit of a single forecast. If specified, all columns
that are not part of the forecast unit (or required columns) will be removed.}

\item{observed}{(optional) Name of the column in \code{data} that contains the
observed values. This column will be renamed to "observed".}

\item{predicted}{(optional) Name of the column in \code{data} that contains the
predicted values. This column will be renamed to "predicted".}
}
\value{
A \code{forecast} object of class \code{forecast_point}
}
\description{
When converting a \code{forecast_quantile} object into a \code{forecast_point} object,
the 0.5 quantile is extracted and returned as the point forecast.
}
\section{Required input}{
The input needs to be a data.frame or similar for the default method
with the following columns:
\itemize{
\item \code{observed}: Column of type \code{numeric} with observed values.
\item \code{predicted}: Column of type \code{numeric} with predicted values.
}

For convenience, we recommend an additional column \code{model} holding the name
of the forecaster or model that produced a prediction, but this is not
strictly necessary.

See the \link{example_point} data set for an example.
}

\seealso{
Other functions to create forecast objects: 
\code{\link{as_forecast_binary}()},
\code{\link{as_forecast_nominal}()},
\code{\link{as_forecast_ordinal}()},
\code{\link{as_forecast_quantile}()},
\code{\link{as_forecast_sample}()}
}
\concept{functions to create forecast objects}
\keyword{as_forecast}
\keyword{transform}
