% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.r
\name{AMA_step_size}
\alias{AMA_step_size}
\title{Compute step size Anderson-Morely upper bound on the largest eigenvalue of the Laplacian}
\usage{
AMA_step_size(w, n)
}
\arguments{
\item{w}{vector of weights}

\item{n}{number of points to cluster}
}
\description{
\code{AMA_step_size} computes a step size based on the better of two bounds derived by Anderson 
and Morely.
}
\examples{
data(mammals)
X <- as.matrix(mammals[,-1])
X <- t(scale(X,center=TRUE,scale=FALSE))
n <- ncol(X)

## Pick some weights and a sequence of regularization parameters.
k <- 5
phi <- 0.5
w <- kernel_weights(X,phi)
w <- knn_weights(w,k,n)
AMA_step_size(w,n)
}

