% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMicro.R
\name{plotMicro}
\alias{plotMicro}
\title{Comparison plots}
\usage{
plotMicro(x, p, which.plot = 1:3)
}
\arguments{
\item{x}{an output object of \code{\link[=microaggregation]{microaggregation()}}}

\item{p}{necessary parameter for the box cox transformation (\code{lambda})}

\item{which.plot}{which plot should be created?
\itemize{
\item \code{1}: density traces
\item \code{2}: parallel boxplots
\item \code{3}: differences in totals
}}
}
\value{
returns \code{NULL}; the selected plot is displayed
}
\description{
Plots for the comparison of the original data and perturbed data.
}
\details{
Univariate and multivariate comparison plots are implemented to detect
differences between the perturbed and the original data, but also to compare
perturbed data which are produced by different methods.
}
\examples{
data(free1)
df <- as.data.frame(free1)[, 31:34]
m1 <- microaggregation(df, method = "onedims", aggr = 3)
plotMicro(m1, p = 1, which.plot = 1)
plotMicro(m1, p = 1, which.plot = 2)
plotMicro(m1, p = 1, which.plot = 3)
}
\references{
Templ, M. and Meindl, B., \emph{Software Development for SDC in
R}, Lecture Notes in Computer Science, Privacy in Statistical Databases,
vol. 4302, pp. 347-359, 2006.
}
\seealso{
\code{\link[=microaggregation]{microaggregation()}}
}
\author{
Matthias Templ
}
\keyword{aplot}
