% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manage_hiers.R
\name{manage_hierarchies}
\alias{manage_hierarchies}
\alias{create_node}
\alias{add_nodes}
\alias{delete_nodes}
\title{Create and modify the structure of hierarchies}
\usage{
create_node(total_lab = "Total")

add_nodes(node, node_labs, reference_node)

delete_nodes(node, node_labs, reference_node)
}
\arguments{
\item{total_lab}{the name of the overall total (summation over all contributing)}

\item{node}{a \code{} object as created in \code{create_node()} or returned from
\code{add_nodes()} or \code{delete_nodes()}.}

\item{node_labs}{character name(s) of new elements that should be inserted to or
deleted from a hierarchical structure}

\item{reference_node}{character name of an existing node in the hierarchical
structure. When using \code{add_nodes()}, the new elements are created as children
of the reference node. In \code{delete_nodes()}, all children of the reference node that
match the names with argument \code{node_labs} are deleted from the hierarchy.}
}
\value{
a \code{Node} object that can be used to specify a hierarchy used
to define table inputs in \code{\link{protectTable}}.
}
\description{
Functions \code{create_node()}, \code{add_nodes()}
and \code{delete_nodes()} allow to define and modify hierarchical structures
represented as trees. These objects can be used in \code{\link{makeProblem}} to
define the (hierarchical) structure of tables.
}
\examples{
dim <- create_node(total_lab="Total")
dim <- add_nodes(dim, reference_node="Total", node_labs=LETTERS[1:4])
print(dim)

## add some levels below "A" and "C"
dim <- add_nodes(dim, reference_node="A", node_labs=paste0("a", 1:5))
dim <- add_nodes(dim, reference_node="C", node_labs=paste0("c", 1:5))
print(dim)

## delete some specific levels
dim <- delete_nodes(dim, reference_node="A", node_labs=c("a1", "a4"))
print(dim)

## delete entire subtree
dim <- delete_nodes(dim, reference_node="Total", node_labs=c("C"))
print(dim)
# plot(dim)
}
