% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{linProb-class}
\alias{linProb-class}
\title{S4 class describing a linProb-object}
\description{
An object of class \code{linProb} defines a linear problem given by the
objective coefficients (slot \code{objective}), a constraint matrix (slot
\code{constraints}), the direction (slot \code{direction}) and the right
hand side (slot \code{rhs}) of the constraints. Also, allowed lower (slot
\code{boundsLower}) and upper (slot \code{boundsUpper}) bounds of the
variables as well as its types (slot \code{types}) are specified.
}
\details{
\describe{
\item{slot \code{objective}:}{a numeric vector holding coefficients of the objective function}
\item{slot \code{constraints}:}{an object of class \code{\link{simpleTriplet-class}} specifying the constraint matrix of the problem}
\item{slot \code{direction}:}{a character vector holding the directions of the constraints, allowed values are:
\itemize{
\item \code{==}: equal
\item \code{<}: less
\item \code{>}: greater
\item \code{<=}: less or equal
\item \code{>=}: greater or equal}
}
\item{slot \code{rhs}:}{numeric vector holding right hand side values of the constraints}
\item{slot \code{boundsLower}:}{a numeric vector holding lower bounds of the objective variables}
\item{slot \code{boundsUpper}:}{a numeric vector holding upper bounds of the objective variables}
\item{slot \code{types}:}{a character vector specifying types of the objective variables, allowed types are:
\itemize{
\item \code{C}: binary
\item \code{B}: continuous
\item \code{I}: integer}
}
}
}
\note{
when solving the problems in the procedure, minimization of the objective is performed.
}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}
