% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_problems.R
\name{sdc_testproblem}
\alias{sdc_testproblem}
\title{A Problem-Instance used for examples/testing}
\usage{
sdc_testproblem(with_supps = FALSE)
}
\arguments{
\item{with_supps}{if \code{TRUE}, a single cell (violating minimal-frquency rule
with \code{n} = 2) is marked as primary sensitive.}
}
\value{
a problem instance
}
\description{
\code{\link[=sdc_testproblem]{sdc_testproblem()}} returns a sdc-problem instance with \code{2} hierarchies and
optionally with a single suppressed cell that is used in various examples
and tests.
}
\examples{
p1 <- sdc_testproblem(); p1
sdcProb2df(p1)

# a single protected cell
p2 <- sdc_testproblem(with_supps = TRUE); p2
sdcProb2df(p2)

# cell status differs in one cell
specs <- c(gender = "female", region = c("A"))
cell_info(p1, specs = specs)
cell_info(p2, specs = specs)
}
