% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{logLikWouPairs}
\alias{logLikWouPairs}
\title{Loglikelihood of WN in 2D when only the initial and final points are observed}
\usage{
logLikWouPairs(x, t, alpha, mu, sigma, rho = 0, maxK = 2L, expTrc = 30)
}
\arguments{
\item{x}{a matrix of dimension \code{c(n, 4)} of initial and final pairs of angles. Each row is an observation containing \eqn{(\phi_0, \psi_0, \phi_t, \psi_t)}.
They all must be in \eqn{[\pi,\pi)} so that the truncated wrapping by \code{maxK} windings is able to capture periodicity.}

\item{t}{either a scalar or a vector of length \code{n} containing the times the initial and final dihedrals. If \code{t} is a scalar, a common time is assumed.}

\item{alpha}{vector of length \code{3} parametrizing the \code{A} matrix as in \code{\link{alphaToA}}.}

\item{mu}{a vector of length \code{2} giving the mean.}

\item{sigma}{vector of length \code{2} containing the \strong{square root} of the diagonal of \eqn{\Sigma}, the diffusion matrix.}

\item{rho}{correlation coefficient of \eqn{\Sigma}.}

\item{maxK}{maximum absolute value of the windings considered in the computation of the WN.}

\item{expTrc}{truncation for exponential: \code{exp(x)} with \code{x <= -expTrc} is set to zero. Defaults to \code{30}.}
}
\value{
A scalar giving the final loglikelihood, defined as the sum of the loglikelihood of the initial angles according to the stationary density
and the loglikelihood of the transitions from initial to final angles.
}
\description{
Computation of the loglikelihood for a WN diffusion (with diagonal diffusion matrix) from a sample of initial and final pairs of angles.
}
\details{
A negative penalty is added if positive definiteness is violated. If the output value is Inf, -100 * N is returned instead.
}
\examples{
set.seed(345567)
x <- toPiInt(matrix(rnorm(200, mean = pi), ncol = 4, nrow = 50))
alpha <- c(2, 1, -0.5)
mu <- c(0, pi)
sigma <- sqrt(c(2, 1))

# The same
logLikWouPairs(x = x, t = 0.5, alpha = alpha, mu = mu, sigma = sigma)
sum(
  log(dStatWn2D(x = x[, 1:2], alpha = alpha, mu = mu, sigma = sigma)) +
  log(dTpdWou2D(x = x[, 3:4], x0 = x[, 1:2], t = 0.5, alpha = alpha, mu = mu,
                 sigma = sigma))
)

# Different times
logLikWouPairs(x = x, t = (1:50) / 50, alpha = alpha, mu = mu, sigma = sigma)
}
