% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/citations.R
\name{layer_citations}
\alias{layer_citations}
\title{Generate citations for all layers}
\usage{
layer_citations(layers = c(), astext = TRUE)
}
\arguments{
\item{layers}{character vector. Code of the layers from past, current and future climate layers. When no layers are
provided (default), then all citations are returned.}

\item{astext}{logical. When \code{TRUE} (default), then citations are 
returned as text otherwise they are returned as 
"\code{\link[utils]{bibentry}}" objects.}
}
\value{
Either a character vector or a list of 
  "\code{\link[utils]{bibentry}}" objects.
}
\description{
\code{layer_citations} returns layer citations as text or as 
"\code{\link[utils]{bibentry}}" objects.
}
\details{
Note that for some layers multiple references are returned as some
  of the predictors have been published separately.
}
\examples{
# print the citation for the Bio-ORACLE salinity layer
print(layer_citations("BO_salinity"))

# print the citation for a MARSPEC paleo layer
print(layer_citations("MS_biogeo02_aspect_NS_21kya"))

# print all citations as Bibtex
print(lapply(layer_citations(astext = FALSE), toBibtex))
}
\seealso{
\code{\link{layer_citations}}, \code{\link[utils]{bibentry}}, \code{\link{list_datasets}}
}
