% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\encoding{UTF-8}
\name{pearson_correlation_matrix}
\alias{pearson_correlation_matrix}
\title{Calculate the Pearson correlation coefficient matrix for a rasterstack}
\usage{
pearson_correlation_matrix(x, cachesize = 20)
}
\arguments{
\item{x}{RasterStack. The stack of rasters you want to calculate the Pearson 
correlation coefficient matrix for. This can be obtained by calling 
\code{\link{load_layers}}.}

\item{cachesize}{integer. For how many rasters should the values be kept in 
local memory. By default this is set to 20, a parameter which works 
reasonably well on a windows computer with 8GB RAM.}
}
\value{
A correlation matrix.
}
\description{
Calculate the Pearson correlation coefficient matrix for a rasterstack
}
\examples{
\dontrun{
# calculate correlation between SST and salinity in the Baltic Sea

# warning using tempdir() implies that data will be downloaded again in the 
# next R session
x <- load_layers(c("BO_sstmax", "BO_salinity"), datadir = tempdir())
e <- extent(13, 31, 52, 66)
baltics <- crop(x, e)
print(pearson_correlation_matrix(baltics))
}
}
\seealso{
\code{\link{layers_correlation} \link{plot_correlation}
  \link{load_layers}}
}

