% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dwd.R
\name{dwd}
\alias{dwd}
\title{Distance Weighted Discrimination}
\usage{
dwd(Ap, An, penalty)
}
\arguments{
\item{Ap}{An nxp point configuration matrix}

\item{An}{An nxp point configuration matrix}

\item{penalty}{A real valued scalar penalty for moving points across classification rule}
}
\value{
Returns an object of class sqlp_input, containing the following:

\item{blk}{A matrix object describing the block diagonal structure of the SQLP data}
\item{At}{A matrix object containing constraint matrices for the primal-dual problem}
\item{C}{A matrix object containing the constant c matrices in the primal objective function}
\item{b}{A vector containing the right hand side of the equality constraints in the primal problem}
\item{OPTIONS}{A list object specifying the value of parbarrier}
}
\description{
\code{dwd} creates input for sqlp to solve the Distance Weighted Discrimination problem -
Given two sets of points An and Ap, find an optimal classification rule to group the points as accurately
as possible for future classification.
}
\details{
Solves the distance weighted discrimination problem. Mathematical and implementation
details can be found in the vignette
}
\examples{
data(Andwd)
data(Apdwd)
penalty <- 0.5

out <- dwd(Apdwd,Andwd,penalty)
blk <- out$blk
At <- out$At
C <- out$C
b <- out$b

}

