\name{predict.sdwd}
\alias{predict.sdwd}
\title{make predictions for the sparse DWD}

\description{
This function predicts the binary class labels or the fitted values of an \code{\link{sdwd}} object.
}

\usage{
\method{predict}{sdwd}(object, newx, s=NULL, type=c("class", "link"), ...)
}

\arguments{
    \item{object}{A fitted \code{\link{sdwd}} object.}
    \item{newx}{A matrix of new values for \code{x} at which predictions are to be made. We note that \code{newx} must be a matrix, \code{predict} function does not accept a vector or other formats of \code{newx}.}
    \item{s}{Value(s) of the L1 tuning parameter \code{lambda} for computing coefficients. Default is the entire \code{lambda} sequence obtained by \code{\link{sdwd}}.}
    \item{type}{\code{"class"} or \code{"link"}? \code{"class"} produces the predicted binary class labels.\code{"link"} returns the fitted values. Default is \code{"class"}.}
    \item{\dots}{Not used. Other arguments to \code{predict}.} 
}
 
\details{\code{s} stands for the new \code{lambda} values for making predictions. If \code{s} is not in the original \code{lambda} sequence generated by \code{\link{sdwd}}, the \code{predict.sdwd} function will use linear interpolation by using a fraction of predicted values from the \code{lambda} values in the original sequence adjacent to the \code{s} to make predictions. The \code{\link{predict.sdwd}} function is modified based on the \code{predict} function from the \code{glmnet} and the \code{gcdnet} packages.}

\value{Returns either the predicted class labels or the fitted values, depending on the choice of \code{type}.}

\author{Boxiang Wang and Hui Zou\cr
Maintainer: Boxiang Wang  \email{boxiang-wang@uiowa.edu}}
\references{
Wang, B. and Zou, H. (2016)
  ``Sparse Distance Weighted Discrimination", \emph{Journal of Computational and Graphical Statistics}, \bold{25}(3), 826--838.\cr
  \url{https://www.tandfonline.com/doi/full/10.1080/10618600.2015.1049700}\cr
  \cr
Yang, Y. and Zou, H. (2013)
``An Efficient Algorithm for Computing the HHSVM and Its Generalizations", 
  \emph{Journal of Computational and Graphical Statistics}, \bold{22}(2), 396--415.\cr
  \url{https://www.tandfonline.com/doi/full/10.1080/10618600.2012.680324}\cr
 \cr 
Friedman, J., Hastie, T., and Tibshirani, R. (2010), "Regularization paths for generalized
linear models via coordinate descent," \emph{Journal of Statistical Software}, \bold{33}(1), 1--22.\cr
\url{http://www.jstatsoft.org/v33/i01/paper}
}
 
\seealso{\code{\link{coef.sdwd}}}
\examples{
data(colon)
fit = sdwd(colon$x, colon$y, lambda2=1)
print(predict(fit ,type="class",newx=colon$x[2:5,]))
}
